% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/browse.R
\name{browse_resource}
\alias{browse_resource}
\title{Open the resource's package page in your browser}
\usage{
browse_resource(resource)
}
\arguments{
\item{resource}{A way to identify the resource. Either a resource ID (passed as a character vector directly) or a single resource resulting from \code{\link{list_package_resources}}.}
}
\value{
A browser is opened to the resource's package page on the City of Toronto Open
Data Portal website if the session is interactive. The URL is returned as a character
string.
}
\description{
Opens a browser to the resource's package page on the City of Toronto Open Data Portal.
}
\examples{
\donttest{
ttc_subway_delays <- search_packages("ttc subway delay")
res <- list_package_resources(ttc_subway_delays)
browse_resource(res[1, ])
}
}
