% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apps.R
\name{apps}
\alias{apps}
\alias{install_apps}
\alias{remove_apps}
\alias{installed_apps}
\alias{available_apps}
\title{OpenCPU Application}
\usage{
install_apps(repo, ...)

remove_apps(repo)

installed_apps()

available_apps()
}
\arguments{
\item{repo}{a github repository such as \code{user/repo}, see \link{install_github}.}

\item{...}{additional options for \code{install_github}}
}
\description{
Manage installed OpenCPU applications. These applications can be started locally
using \link{ocpu_start_app} or deployed online on \href{https://ocpu.io}{ocpu.io}.
}
\details{
OpenCPU apps are simply R packages. For regular users, apps get installed in a
user-specific app library which is persistent between R sessions. This is used
for locally running or developing web applications.

When running these functions as \code{opencpu} user on an OpenCPU cloud server, apps
will be installed in the global opencpu server app library; the same library as used
by the OpenCPU Github webhook.
}
\examples{
\dontrun{
# List available demo apps
available_apps()

# Run application from: https://github.com/rwebapps/nabel
ocpu_start_app("rwebapps/nabel")

# Run application from: https://github.com/rwebapps/markdownapp
ocpu_start_app("rwebapps/markdownapp")

# Run application from: https://github.com/rwebapps/stockapp
ocpu_start_app("rwebapps/stockapp")

# Run application from: https://github.com/rwebapps/appdemo
ocpu_start_app("rwebapps/appdemo")

# Show currently installed apps
installed_apps()
}
}
\seealso{
Other ocpu: \code{\link{ocpu-server}}
}
