% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oa_fetch.R
\name{oa_fetch}
\alias{oa_fetch}
\title{Fetching records}
\usage{
oa_fetch(
  entity = if (is.null(identifier)) NULL else id_type(shorten_oaid(identifier[[1]])),
  identifier = NULL,
  ...,
  options = NULL,
  search = NULL,
  group_by = NULL,
  output = c("tibble", "dataframe", "list"),
  abstract = TRUE,
  endpoint = "https://api.openalex.org",
  per_page = 200,
  paging = NULL,
  pages = NULL,
  count_only = FALSE,
  mailto = oa_email(),
  api_key = oa_apikey(),
  verbose = FALSE
)
}
\arguments{
\item{entity}{Character. Scholarly entity of the search.
The argument can be one of
c("works", "authors", "institutions", "concepts", "funders", "sources", "publishers").
If not provided, `entity` is guessed from `identifier`.}

\item{identifier}{Character. OpenAlex ID(s) as item identifier(s).
See more at <https://docs.openalex.org/how-to-use-the-api/get-single-entities#the-openalex-id>.}

\item{...}{Additional filter arguments.}

\item{options}{List. Additional parameters to add in the query. For example:

- `select` Character vector. Top-level fields to show in output.
Defaults to NULL, which returns all fields.
https://docs.openalex.org/how-to-use-the-api/get-single-entities/select-fields

- `sort` Character. Attribute to sort by.
For example: "display_name" for sources or "cited_by_count:desc" for works.
See more at <https://docs.openalex.org/how-to-use-the-api/get-lists-of-entities/sort-entity-lists>.

- `sample` Integer. Number of (random) records to return.
Should be no larger than 10,000.
Defaults to NULL, which returns all records satisfying the query.
Read more at <https://docs.openalex.org/how-to-use-the-api/get-lists-of-entities/sample-entity-lists>.

- `seed` Integer.
A seed value in order to retrieve the same set of random records in
the same order when used multiple times with `sample`.
IMPORTANT NOTE: Depending on your query, random results with a seed value may change over time due to new records coming into OpenAlex.
This argument is likely only useful when queries happen close together (within a day).}

\item{search}{Character. Search is just another kind of filter, one that all five endpoints support.
But unlike the other filters, search does NOT require an exact match.
This is particularly useful in author queries because many authors have middle names, which may not exist or do so in a variety of forms.
The `display_name` filter requires an exact match and will NOT find all these authors.
For example, author "Phillip H. Kuo" and "Phillip Hsin Kuo" can only be found either using search = "Phillip Kuo" or display_name = c("Phillip H. Kuo", "Phillip Hsin Kuo").
To filter using search, append .search to the end of the attribute you're filtering for.}

\item{group_by}{Character. Attribute to group by.
For example: "oa_status" for works.
See more at <https://docs.openalex.org/how-to-use-the-api/get-groups-of-entities>.}

\item{output}{Character. Type of output, either a list or a tibble/data.frame.}

\item{abstract}{Logical. If TRUE, the function returns also the abstract of each item.
Default to \code{abstract = TRUE}.
The argument is ignored if entity is different from "works".}

\item{endpoint}{Character. URL of the OpenAlex Endpoint API server.
Defaults to endpoint = "https://api.openalex.org".}

\item{per_page}{Numeric. Number of items to download per page.
The per-page argument can assume any number between 1 and 200.
Defaults to 200.}

\item{paging}{Character.
Either "cursor" for cursor paging or "page" for basic paging.
When used with `options$sample` and or `pages`,
paging is also automatically set to basic paging: `paging = "page"`
to avoid duplicates and get the right page.
See https://docs.openalex.org/how-to-use-the-api/get-lists-of-entities/paging.}

\item{pages}{Integer vector.
The range of pages to return. If NULL, return all pages.}

\item{count_only}{Logical.
If TRUE, the function returns only the number of item matching the query.
Defaults to FALSE.}

\item{mailto}{Character string.
Gives OpenAlex an email to enter the polite pool.}

\item{api_key}{Character string.
Your OpenAlex Premium API key, if available.}

\item{verbose}{Logical. If TRUE, print information on querying process.
Default to \code{verbose = FALSE}.
To shorten the printed query URL, set the environment variable openalexR.print
to the number of characters to print: \code{Sys.setenv(openalexR.print = 70)}.}
}
\value{
A data.frame or a list. Result of the query.
}
\description{
A composition function to perform query building, requesting,
and convert the result to a tibble/data frame.
}
\examples{
\dontrun{

paper_meta <- oa_fetch(
  identifier = "W2755950973",
  entity = "works",
  count_only = TRUE,
  abstract = TRUE,
  verbose = TRUE
)

oa_fetch(
  entity = "works",
  doi = c(
    "10.1371/journal.pone.0266781",
    "10.1371/journal.pone.0267149"
  ),
  verbose = TRUE,
  count_only = TRUE
)

oa_fetch(
  entity = "works",
  doi = c(
    "10.1371/journal.pone.0266781",
    "10.1371/journal.pone.0267149"
  ),
  options = list(select = c("doi", "id", "cited_by_count", "type")),
  verbose = TRUE
)

oa_fetch(
  identifier = c("A5069892096", "A5023888391"),
  verbose = TRUE
)
}
}
