% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openai.R
\name{openai}
\alias{openai}
\title{An R6 Class Interface to OpenAI API}
\description{
Provides methods to interact with OpenAI API including
  fetching model details, generating completions, managing files, and more.
  Always ensure that the API key is kept private.
}
\examples{
if(file.exists("openai-key")){
  key <- readLines(file("openai-key"))
  #NOTE To retrieve the correct data, it is necessary to provide an 'openaikey';
  # otherwise, an exception will be returned.
}else{
  key <- "you_api_key"
}
aaa <- openai$new(key)
#if need proxy
#aaa$set_proxy("127.0.0.1", 10890)
# List model
aaa$get_model_list()
\donttest{
#The following request will cause a timeout when the correct key is not present,
# so it is not necessary to test it during the check.
# Upload a file
train_file_path<-system.file("exdata","train.jsonl", package = "openaistream")
file_id <- aaa$files_upload(path = train_file_path,purpose = "fine-tune")
# Retrieve a file's details
aaa$files_retrieve(NULL, verbosity = 0)
# Delete a file
#aaa$files_delete(file_id$id, verbosity = 0)
# Get a list of files
aaa$files_get_list()
#aaa
job<-aaa$fine_tuning_jobs_create(model = "gpt-3.5-turbo",training_file = file_id$id)
aaa$files_delete(file_id$id, verbosity = 0)
# List fine-tuning jobs
aaa$fine_tuning_jobs_list(limit = 2, verbosity = 3)
# Retrieve details of a specific fine-tuning job
aaa$fine_tuning_jobs_retrieve(job$id, verbosity = 0)
# Get events related to a specific fine-tuning job
aaa$fine_tuning_jobs_events(job$id, verbosity = 3)
# Compute embeddings for input data
aaa$embeddings(model = "text-embedding-ada-002", input = "who are you?")
# chat test not stream
streamlg <- aaa$get_completions_query(
  prompt = "Please explain the World Wars?",
  model = "davinci-002",
  stream = FALSE,
  max_tokens = 20,
  num = 4,
  verbosity = 0
)

# chat test stream
streamlg <- aaa$get_chat_completions_query(
  messages = data.frame(role = c("system", "user"),
                        content = c("You are a assistant.", "How's the weather today?")),
  model = "gpt-3.5-turbo",
  stream = TRUE,
  max_tokens = 10
)

streamlg$get_state()
streamlg$next_value
streamlg$close()
streamlg$next_value
streamlg$get_state()
sss<-aaa$audio_speech(input = "Hi, this is a voice transmission test.",response_format="mp3")
#writeBin(sss,"test.mp3")
#text_E1<-aaa$audio_transcriptions(path = "test.mp3")
#text_E2<-aaa$audio_translations(path = "test.mp3")
pic1<-aaa$images_generations(prompt = "A small bird flies over the ocean")
#req <- request(pic1$data$url) \%>\%req_perform(path = "pic1.png")
#Here is the image test.
#For simple test,you need install 'png' package.
#Note that when a mask is not provided, OpenAI defaults to using areas of the uploaded image
#  with a transparency of 0 as the modification area.
#The following test adds full image transparency of 0 (modifying the entire image) to pic1.
# pic1<-readPNG("pic1.png")
# if (dim(pic1)[3] == 3) {  # Checking if the image is RGB
#   # Adding an alpha channel (fully opaque)
#   alpha_channel <- matrix(0, nrow = dim(pic1)[1], ncol = dim(pic1)[2])
#   pic1_b<-array(c(pic1,alpha_channel), c(1024,1024,4))
# }
# writePNG(pic1_b,target = "pic1_b.png")
# pic3<-aaa$images_edits(image = "pic1_b.png",
# prompt = "Please modify the bird in the picture to a flock of birds."
#  ,verbosity = 3,n="2",size="256x256")
# request(pic3$data$url[1]) \%>\%req_perform(path = "pic3_1.png")
# request(pic3$data$url[2]) \%>\%req_perform(path = "pic3_2.png")
#
# pic4<-aaa$images_variations(image = "pic1.png",n="2",size="256x256")
# request(pic4$data$url[1]) \%>\%req_perform(path = "pic4_1.png")
# request(pic4$data$url[2]) \%>\%req_perform(path = "pic4_2.png")
}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-openai-new}{\code{openai$new()}}
\item \href{#method-openai-set_proxy}{\code{openai$set_proxy()}}
\item \href{#method-openai-get_model_list}{\code{openai$get_model_list()}}
\item \href{#method-openai-get_model_retrieve}{\code{openai$get_model_retrieve()}}
\item \href{#method-openai-fine_tuning_jobs_delete}{\code{openai$fine_tuning_jobs_delete()}}
\item \href{#method-openai-get_completions_query}{\code{openai$get_completions_query()}}
\item \href{#method-openai-get_chat_completions_query}{\code{openai$get_chat_completions_query()}}
\item \href{#method-openai-files_upload}{\code{openai$files_upload()}}
\item \href{#method-openai-files_get_list}{\code{openai$files_get_list()}}
\item \href{#method-openai-files_delete}{\code{openai$files_delete()}}
\item \href{#method-openai-files_retrieve}{\code{openai$files_retrieve()}}
\item \href{#method-openai-fine_tuning_jobs_create}{\code{openai$fine_tuning_jobs_create()}}
\item \href{#method-openai-fine_tuning_jobs_list}{\code{openai$fine_tuning_jobs_list()}}
\item \href{#method-openai-fine_tuning_jobs_retrieve}{\code{openai$fine_tuning_jobs_retrieve()}}
\item \href{#method-openai-fine_tuning_jobs_cancel}{\code{openai$fine_tuning_jobs_cancel()}}
\item \href{#method-openai-fine_tuning_jobs_events}{\code{openai$fine_tuning_jobs_events()}}
\item \href{#method-openai-embeddings}{\code{openai$embeddings()}}
\item \href{#method-openai-audio_speech}{\code{openai$audio_speech()}}
\item \href{#method-openai-audio_transcriptions}{\code{openai$audio_transcriptions()}}
\item \href{#method-openai-audio_translations}{\code{openai$audio_translations()}}
\item \href{#method-openai-images_generations}{\code{openai$images_generations()}}
\item \href{#method-openai-images_edits}{\code{openai$images_edits()}}
\item \href{#method-openai-images_variations}{\code{openai$images_variations()}}
\item \href{#method-openai-clone}{\code{openai$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-new"></a>}}
\if{latex}{\out{\hypertarget{method-openai-new}{}}}
\subsection{Method \code{new()}}{
Initialize the OpenAI API interface with the provided API key.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$new(api_key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{api_key}}{The OpenAI API key.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-set_proxy"></a>}}
\if{latex}{\out{\hypertarget{method-openai-set_proxy}{}}}
\subsection{Method \code{set_proxy()}}{
Configure the proxy settings.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$set_proxy(proxy_ip, proxy_port)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{proxy_ip}}{The IP address of the proxy.}

\item{\code{proxy_port}}{The port number of the proxy.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-get_model_list"></a>}}
\if{latex}{\out{\hypertarget{method-openai-get_model_list}{}}}
\subsection{Method \code{get_model_list()}}{
Retrieve a list of available models from OpenAI.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$get_model_list(verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verbosity}}{Verbosity level for the API call.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of available models.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-get_model_retrieve"></a>}}
\if{latex}{\out{\hypertarget{method-openai-get_model_retrieve}{}}}
\subsection{Method \code{get_model_retrieve()}}{
Retrieve details of a specific model from OpenAI.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$get_model_retrieve(model, verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{The model ID.}

\item{\code{verbosity}}{Verbosity level for the API call.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Details of the specified model.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-fine_tuning_jobs_delete"></a>}}
\if{latex}{\out{\hypertarget{method-openai-fine_tuning_jobs_delete}{}}}
\subsection{Method \code{fine_tuning_jobs_delete()}}{
Delete a fine-tuned model from OpenAI.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$fine_tuning_jobs_delete(model_id, verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model_id}}{The ID of the file to delete.}

\item{\code{verbosity}}{Verbosity level for the API call.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Response indicating the success or failure of the delete operation.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-get_completions_query"></a>}}
\if{latex}{\out{\hypertarget{method-openai-get_completions_query}{}}}
\subsection{Method \code{get_completions_query()}}{
Get completions for a given prompt using a specific model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$get_completions_query(
  prompt,
  model,
  stream = F,
  num = 2,
  verbosity = 0,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prompt}}{The input text to get completions for.}

\item{\code{model}}{The model to use for generating completions.}

\item{\code{stream}}{A boolean indicating whether to stream the results.}

\item{\code{num}}{The num parameter controls the number of text entries returned by a stream in one go.
Note that this is different from the n parameter, which specifies the number of results returned.
For detailed information on the n parameter, please refer to OpenAI's API documentation.}

\item{\code{verbosity}}{Verbosity level for the API call.}

\item{\code{...}}{Additional parameters as required by the OpenAI API.For example:max_tokens;n;stop;temperature......}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Completions based on the input prompt.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-get_chat_completions_query"></a>}}
\if{latex}{\out{\hypertarget{method-openai-get_chat_completions_query}{}}}
\subsection{Method \code{get_chat_completions_query()}}{
Generate conversational completions using chat models.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$get_chat_completions_query(
  messages,
  model,
  stream = F,
  num = 2,
  verbosity = 0,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{messages}}{A list of message objects, where each message has a role and content.}

\item{\code{model}}{The model to use for generating chat completions.}

\item{\code{stream}}{A boolean indicating whether to stream the results.}

\item{\code{num}}{The num parameter controls the number of text entries returned by a stream in one go.
Note that this is different from the n parameter, which specifies the number of results returned.
For detailed information on the n parameter, please refer to OpenAI's API documentation.}

\item{\code{verbosity}}{Verbosity level for the API call.}

\item{\code{...}}{Additional parameters as required by the OpenAI API.For example:max_tokens;n;stop;temperature......}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Completions based on the conversational context.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-files_upload"></a>}}
\if{latex}{\out{\hypertarget{method-openai-files_upload}{}}}
\subsection{Method \code{files_upload()}}{
Upload a file to OpenAI.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$files_upload(path, verbosity = 0, purpose)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Path to the file that needs to be uploaded.}

\item{\code{verbosity}}{Verbosity level for the API call.}

\item{\code{purpose}}{Purpose of the file (e.g., "fine-tune").}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Response indicating the success or failure of the upload operation.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-files_get_list"></a>}}
\if{latex}{\out{\hypertarget{method-openai-files_get_list}{}}}
\subsection{Method \code{files_get_list()}}{
Retrieve a list of files from OpenAI.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$files_get_list(verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verbosity}}{Verbosity level for the API call.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of files.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-files_delete"></a>}}
\if{latex}{\out{\hypertarget{method-openai-files_delete}{}}}
\subsection{Method \code{files_delete()}}{
Delete a file from OpenAI.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$files_delete(file_id, verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file_id}}{The ID of the file to delete.}

\item{\code{verbosity}}{Verbosity level for the API call.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Response indicating the success or failure of the delete operation.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-files_retrieve"></a>}}
\if{latex}{\out{\hypertarget{method-openai-files_retrieve}{}}}
\subsection{Method \code{files_retrieve()}}{
Retrieve details of a specific file from OpenAI.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$files_retrieve(file_id, verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file_id}}{The ID of the file to retrieve details for.}

\item{\code{verbosity}}{Verbosity level for the API call.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Details of the specified file.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-fine_tuning_jobs_create"></a>}}
\if{latex}{\out{\hypertarget{method-openai-fine_tuning_jobs_create}{}}}
\subsection{Method \code{fine_tuning_jobs_create()}}{
Create a fine-tuning job in OpenAI.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$fine_tuning_jobs_create(
  model,
  training_file,
  hyperparameters = list(n_epochs = 1),
  verbosity = 0,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{The model ID.}

\item{\code{training_file}}{The file used for training.}

\item{\code{hyperparameters}}{params list for the fine-tuning include batch_size;learning_rate_multiplier;n_epochs.}

\item{\code{verbosity}}{Verbosity level for the API call.}

\item{\code{...}}{Additional parameters as required by the OpenAI API.For example:validation_file......}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Response indicating the success or failure of the fine-tuning job creation.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-fine_tuning_jobs_list"></a>}}
\if{latex}{\out{\hypertarget{method-openai-fine_tuning_jobs_list}{}}}
\subsection{Method \code{fine_tuning_jobs_list()}}{
List fine-tuning jobs from OpenAI.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$fine_tuning_jobs_list(verbosity = 0, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verbosity}}{Verbosity level for the API call.}

\item{\code{...}}{Additional parameters as required by the OpenAI API.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of fine-tuning jobs.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-fine_tuning_jobs_retrieve"></a>}}
\if{latex}{\out{\hypertarget{method-openai-fine_tuning_jobs_retrieve}{}}}
\subsection{Method \code{fine_tuning_jobs_retrieve()}}{
Retrieve details of a specific fine-tuning job from OpenAI.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$fine_tuning_jobs_retrieve(job_id, verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{job_id}}{The ID of the fine-tuning job.}

\item{\code{verbosity}}{Verbosity level for the API call.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Details of the specified fine-tuning job.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-fine_tuning_jobs_cancel"></a>}}
\if{latex}{\out{\hypertarget{method-openai-fine_tuning_jobs_cancel}{}}}
\subsection{Method \code{fine_tuning_jobs_cancel()}}{
Cancel a specific fine-tuning job in OpenAI.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$fine_tuning_jobs_cancel(job_id, verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{job_id}}{The ID of the fine-tuning job to cancel.}

\item{\code{verbosity}}{Verbosity level for the API call.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Response indicating the success or failure of the cancel operation.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-fine_tuning_jobs_events"></a>}}
\if{latex}{\out{\hypertarget{method-openai-fine_tuning_jobs_events}{}}}
\subsection{Method \code{fine_tuning_jobs_events()}}{
Get events related to a specific fine-tuning job from OpenAI.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$fine_tuning_jobs_events(job_id, verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{job_id}}{The ID of the fine-tuning job to retrieve events for.}

\item{\code{verbosity}}{Verbosity level for the API call.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of events related to the specified fine-tuning job.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-embeddings"></a>}}
\if{latex}{\out{\hypertarget{method-openai-embeddings}{}}}
\subsection{Method \code{embeddings()}}{
Compute embeddings for input data using a specified model in OpenAI.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$embeddings(model, input, verbosity = 0, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{The model to use for generating embeddings.}

\item{\code{input}}{Input data to generate embeddings for.}

\item{\code{verbosity}}{Verbosity level for the API call.}

\item{\code{...}}{Additional parameters as required by the OpenAI API.For example:encoding_format;user....}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Embeddings for the input data.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-audio_speech"></a>}}
\if{latex}{\out{\hypertarget{method-openai-audio_speech}{}}}
\subsection{Method \code{audio_speech()}}{
Generates audio from the input text.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$audio_speech(
  model = "tts-1",
  input,
  voice = "alloy",
  verbosity = 0,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{One of the available TTS models: tts-1 or tts-1-hd}

\item{\code{input}}{The text to generate audio for. The maximum length is 4096 characters.}

\item{\code{voice}}{The voice to use when generating the audio. Supported voices are alloy, echo, fable, onyx, nova, and shimmer.}

\item{\code{verbosity}}{Verbosity level for the API call.}

\item{\code{...}}{Additional parameters as required by the OpenAI API.For example:response_format;speed....}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The audio file content.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-audio_transcriptions"></a>}}
\if{latex}{\out{\hypertarget{method-openai-audio_transcriptions}{}}}
\subsection{Method \code{audio_transcriptions()}}{
Transcribes audio into the input language.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$audio_transcriptions(path, model = "whisper-1", verbosity = 0, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{The audio file object (not file name) to transcribe, in one of these formats: flac, mp3, mp4, mpeg, mpga, m4a, ogg, wav, or webm.}

\item{\code{model}}{ID of the model to use. Only whisper-1 is currently available.}

\item{\code{verbosity}}{Verbosity level for the API call.}

\item{\code{...}}{Additional parameters as required by the OpenAI API.For example:language;prompt;response_format;temperature....}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The transcribed text.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-audio_translations"></a>}}
\if{latex}{\out{\hypertarget{method-openai-audio_translations}{}}}
\subsection{Method \code{audio_translations()}}{
Translates audio into English.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$audio_translations(path, model = "whisper-1", verbosity = 0, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{The audio file object (not file name) to transcribe, in one of these formats: flac, mp3, mp4, mpeg, mpga, m4a, ogg, wav, or webm.}

\item{\code{model}}{ID of the model to use. Only whisper-1 is currently available.}

\item{\code{verbosity}}{Verbosity level for the API call.}

\item{\code{...}}{Additional parameters as required by the OpenAI API.For example:prompt;response_format;temperature....}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The transcribed text.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-images_generations"></a>}}
\if{latex}{\out{\hypertarget{method-openai-images_generations}{}}}
\subsection{Method \code{images_generations()}}{
Creates an image given a prompt.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$images_generations(prompt, verbosity = 0, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prompt}}{A text description of the desired image(s). The maximum length is 1000 characters for dall-e-2 and 4000 characters for dall-e-3}

\item{\code{verbosity}}{Verbosity level for the API call.}

\item{\code{...}}{Additional parameters as required by the OpenAI API.For example:n;quality;response_format...}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns a list of image objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-images_edits"></a>}}
\if{latex}{\out{\hypertarget{method-openai-images_edits}{}}}
\subsection{Method \code{images_edits()}}{
Creates an edited or extended image given an original image and a prompt.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$images_edits(image, prompt, verbosity = 0, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{image}}{The image to edit. Must be a valid PNG file, less than 4MB, and square. If mask is not provided, image must have transparency, which will be used as the mask.}

\item{\code{prompt}}{A text description of the desired image(s). The maximum length is 1000 characters.}

\item{\code{verbosity}}{Verbosity level for the API call.}

\item{\code{...}}{Additional parameters as required by the OpenAI API.For example:mask;model;n...}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns a list of image objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-images_variations"></a>}}
\if{latex}{\out{\hypertarget{method-openai-images_variations}{}}}
\subsection{Method \code{images_variations()}}{
Creates a variation of a given image.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$images_variations(image, verbosity = 0, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{image}}{The image to use as the basis for the variation(s). Must be a valid PNG file, less than 4MB, and square.}

\item{\code{verbosity}}{Verbosity level for the API call.}

\item{\code{...}}{Additional parameters as required by the OpenAI API.For example:model;n;response_format}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns a list of image objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-clone"></a>}}
\if{latex}{\out{\hypertarget{method-openai-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
