% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CSMF.r
\name{getIndivProb}
\alias{getIndivProb}
\title{Extract individual distribution of cause of death}
\usage{
getIndivProb(x, CI = NULL)
}
\arguments{
\item{x}{a fitted object from \code{codeVA}.}

\item{CI}{Credible interval for posterior estimates. If CI is set to TRUE, a list is returned instead of a data frame.}
}
\value{
a data frame of COD distribution for each individual specified by row names.
}
\description{
Extract individual distribution of cause of death
}
\examples{
data(RandomVA1)
# for illustration, only use interVA on 100 deaths
fit <- codeVA(RandomVA1[1:100, ], data.type = "WHO", model = "InterVA", 
                  version = "4.02", HIV = "h", Malaria = "l")
probs <- getIndivProb(fit)

}
