/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.namefind;

import java.util.LinkedList;
import opennlp.tools.util.Span;
import opennlp.uima.util.AnnotationComboIterator;
import opennlp.uima.util.AnnotationIteratorPair;
import opennlp.uima.util.AnnotatorUtil;
import opennlp.uima.util.UimaUtil;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

abstract class AbstractNameFinder
extends CasAnnotator_ImplBase {
    protected final String name;
    protected Type mSentenceType;
    protected Type mTokenType;
    protected Type mNameType;
    protected UimaContext context;
    protected Logger mLogger;
    private Boolean isRemoveExistingAnnotations;

    AbstractNameFinder(String name) {
        this.name = name;
    }

    protected void initialize() throws ResourceInitializationException {
    }

    public final void initialize(UimaContext context) throws ResourceInitializationException {
        this.context = context;
        this.mLogger = context.getLogger();
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, "Initializing the " + this.name + ".");
        }
        this.isRemoveExistingAnnotations = AnnotatorUtil.getOptionalBooleanParameter(context, "opennlp.uima.IsRemoveExistingAnnotations");
        if (this.isRemoveExistingAnnotations == null) {
            this.isRemoveExistingAnnotations = false;
        }
        this.initialize();
    }

    public void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        this.mSentenceType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, UimaUtil.SENTENCE_TYPE_PARAMETER);
        this.mTokenType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, "opennlp.uima.TokenType");
        this.mNameType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, "opennlp.uima.NameType");
    }

    protected void postProcessAnnotations(Span[] detectedNames, AnnotationFS[] nameAnnotations) {
    }

    protected void documentDone(CAS cas) {
    }

    protected abstract Span[] find(CAS var1, String[] var2);

    public final void process(CAS cas) {
        if (this.isRemoveExistingAnnotations.booleanValue()) {
            AnnotationComboIterator sentenceNameCombo = new AnnotationComboIterator(cas, this.mSentenceType, this.mNameType);
            LinkedList<AnnotationFS> removeAnnotations = new LinkedList<AnnotationFS>();
            for (AnnotationIteratorPair annotationIteratorPair : sentenceNameCombo) {
                for (AnnotationFS nameAnnotation : annotationIteratorPair.getSubIterator()) {
                    removeAnnotations.add(nameAnnotation);
                }
            }
            for (AnnotationFS annotation : removeAnnotations) {
                cas.removeFsFromIndexes((FeatureStructure)annotation);
            }
        }
        AnnotationComboIterator sentenceTokenCombo = new AnnotationComboIterator(cas, this.mSentenceType, this.mTokenType);
        for (AnnotationIteratorPair annotationIteratorPair : sentenceTokenCombo) {
            LinkedList<AnnotationFS> sentenceTokenAnnotationList = new LinkedList<AnnotationFS>();
            LinkedList<String> sentenceTokenList = new LinkedList<String>();
            for (AnnotationFS tokenAnnotation : annotationIteratorPair.getSubIterator()) {
                sentenceTokenAnnotationList.add(tokenAnnotation);
                sentenceTokenList.add(tokenAnnotation.getCoveredText());
            }
            Span[] names = this.find(cas, sentenceTokenList.toArray(new String[sentenceTokenList.size()]));
            AnnotationFS[] nameAnnotations = new AnnotationFS[names.length];
            for (int i = 0; i < names.length; ++i) {
                int startIndex = ((AnnotationFS)sentenceTokenAnnotationList.get(names[i].getStart())).getBegin();
                int endIndex = ((AnnotationFS)sentenceTokenAnnotationList.get(names[i].getEnd() - 1)).getEnd();
                nameAnnotations[i] = cas.createAnnotation(this.mNameType, startIndex, endIndex);
                cas.getIndexRepository().addFS((FeatureStructure)nameAnnotations[i]);
            }
            this.postProcessAnnotations(names, nameAnnotations);
        }
        this.documentDone(cas);
    }
}

