% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.project.R
\name{opal.project_create}
\alias{opal.project_create}
\title{Create a project}
\usage{
opal.project_create(
  opal,
  project,
  database = NULL,
  title = NULL,
  description = NULL,
  tags = NULL,
  exportFolder = NULL
)
}
\arguments{
\item{opal}{Opal object.}

\item{project}{Name of the project}

\item{database}{The database name (as declared in Opal) to be used to store project's data. If not provided, the project
can have views and resources but no raw tables. If the the value is a logical and is TRUE, the default database will be 
selected or the first one if there is no default.}

\item{title}{The title of the project (optional).}

\item{description}{The description of the project (optional).}

\item{tags}{A list of tag names (optional).}

\item{exportFolder}{The default location of the exported data files in the Opal file system (optional).}
}
\description{
Create a project
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
# with named database
opal.project_create(o, 'test', database='opal_data', title='This is a test', tags=list('Test'))
# with default database
opal.project_create(o, 'test_default_db', database = TRUE)
# no database, for views and resources only
opal.project_create(o, 'test_no_db')
opal.logout(o)
}
}
\seealso{
Other project functions: 
\code{\link{opal.project_delete}()},
\code{\link{opal.project_exists}()},
\code{\link{opal.projects_databases}()},
\code{\link{opal.projects}()},
\code{\link{opal.project}()}
}
\concept{project functions}
