% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.users.R
\name{oadmin.user_reset_password}
\alias{oadmin.user_reset_password}
\title{Reset user password}
\usage{
oadmin.user_reset_password(opal, name, password = NULL)
}
\arguments{
\item{opal}{Opal object.}

\item{name}{User name}

\item{password}{User password. If not provided, a password will be generated and returned.}
}
\description{
Reset the password of a user from Opal internal users registry.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
pwd <- oadmin.user_add(o, "foo", groups = c("datashield", "CNSIM"))
oadmin.user_reset_password(o, "foo", password = "password1234")
oadmin.user_rm(o, "foo")
opal.logout(o)
}
}
\seealso{
Other user functions: 
\code{\link{oadmin.user_add}()},
\code{\link{oadmin.user_delete}()},
\code{\link{oadmin.user_enable}()},
\code{\link{oadmin.user_exists}()},
\code{\link{oadmin.user_profile_delete}()},
\code{\link{oadmin.user_profiles}()},
\code{\link{oadmin.users}()}
}
\concept{user functions}
