% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.datasource.R
\name{opal.tables_perm}
\alias{opal.tables_perm}
\title{Get the permissions on any table of a project}
\usage{
opal.tables_perm(opal, project)
}
\arguments{
\item{opal}{Opal connection object.}

\item{project}{Project name.}
}
\value{
A data.frame with columns: subject, type, permission
}
\description{
Get the permissions that were applied on any table of a project.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
opal.tables_perm_add(o, 'CNSIM', c('andrei', 'valentina'), 'user', 'administrate')
opal.tables_perm(o, 'CNSIM')
opal.tables_perm_delete(o, 'CNSIM', c('andrei', 'valentina'), 'user')
opal.logout(o)
}
}
