% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.resource.R
\name{opal.resource_perm_delete}
\alias{opal.resource_perm_delete}
\title{Delete a permission from a resource}
\usage{
opal.resource_perm_delete(opal, project, resource, subject, type = "user")
}
\arguments{
\item{opal}{Opal connection object.}

\item{project}{The project name.}

\item{resource}{The resource name.}

\item{subject}{A vector of subject identifiers: user names or group names (depending on the type).}

\item{type}{The type of subject: user (default) or group.}
}
\description{
Delete a permission that was applied on a resource. Silently returns when there is no such permission.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
opal.resource_perm_add(o, 'CNSIM', 'CNSIM1', c('andrei', 'valentina'), 'user', 'view')
opal.resource_perm(o, 'CNSIM', 'CNSIM1')
opal.resource_perm_delete(o, 'CNSIM', 'CNSIM1', c('andrei', 'valentina'), 'user')
opal.logout(o)
}
}
\seealso{
Other resource functions: 
\code{\link{opal.resource_create}()},
\code{\link{opal.resource_delete}()},
\code{\link{opal.resource_exists}()},
\code{\link{opal.resource_extension_create}()},
\code{\link{opal.resource_get}()},
\code{\link{opal.resource_perm_add}()},
\code{\link{opal.resource_perm}()},
\code{\link{opal.resources_perm_add}()},
\code{\link{opal.resources_perm_delete}()},
\code{\link{opal.resources_perm}()},
\code{\link{opal.resources}()},
\code{\link{opal.resource}()}
}
\concept{resource functions}
