% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.resource.R
\name{opal.resource_get}
\alias{opal.resource_get}
\title{Get the resource object of a project}
\usage{
opal.resource_get(opal, project, resource)
}
\arguments{
\item{opal}{Opal object.}

\item{project}{Name of the project.}

\item{resource}{Name of the resource in the project.}
}
\description{
Get the resource object of a project
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
res <- opal.resource_get(o, 'RSRC', 'CNSIM1')
# then interpret locally the resource object (load the appropriate R packages)
library(resourcer)
# coerce to a data.frame
as.data.frame(res)
# or get the resource client object for low-level interactions
rescli <- resourcer::newResourceClient(res)
opal.logout(o)
}
}
\seealso{
Other resource functions: 
\code{\link{opal.resource_create}()},
\code{\link{opal.resource_delete}()},
\code{\link{opal.resource_exists}()},
\code{\link{opal.resource_extension_create}()},
\code{\link{opal.resource_perm_add}()},
\code{\link{opal.resource_perm_delete}()},
\code{\link{opal.resource_perm}()},
\code{\link{opal.resources_perm_add}()},
\code{\link{opal.resources_perm_delete}()},
\code{\link{opal.resources_perm}()},
\code{\link{opal.resources}()},
\code{\link{opal.resource}()}
}
\concept{resource functions}
