% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.R
\name{opal.login}
\alias{opal.login}
\title{Opal login}
\usage{
opal.login(
  username = getOption("opal.username"),
  password = getOption("opal.password"),
  token = getOption("opal.token"),
  url = getOption("opal.url"),
  opts = getOption("opal.opts", list()),
  profile = getOption("opal.profile"),
  restore = NULL
)
}
\arguments{
\item{username}{User name in opal(s). Can be provided by "opal.username" option.}

\item{password}{User password in opal(s). Can be provided by "opal.password" option.}

\item{token}{Personal access token (since opal 2.15). Only effective if the username or the password is NULL or empty. 
Can be provided by "opal.token" option.}

\item{url}{Opal url or list of opal urls. Can be provided by "opal.url" option.}

\item{opts}{Curl options as described by httr (call httr::httr_options() for details). Can be provided by "opal.opts" option.}

\item{profile}{R server profile name. This will drive the R server in which a R session will be created. If no remote R session
is needed (because Opal specific operations are done), this parameter does not need to be provided. Otherwise, if missing, the default 
R server profile will be applied ('default'). See also \link{opal.profiles}.}

\item{restore}{Workspace ID to be restored (see also opal.logout)}
}
\value{
A opal object or a list of opal objects.
}
\description{
Log in Opal(s).
}
\examples{
\dontrun{
#### The below examples illustrate the different ways to login in opal ####

# explicite username/password login
o <- opal.login(username = 'administrator', password = 'password', 
                url = 'https://opal-demo.obiba.org')
opal.logout(o)

 # explicite personal access token login
o <- opal.login(token = 'HYG16LO0VaX4O0UardNbiqmr2ByBpRke', 
                url = 'https://opal-demo.obiba.org')
opal.logout(o)

# login using options and user credentials
options(opal.username = 'administrator',
 opal.password = 'password',
 opal.url = 'https://opal-demo.obiba.org')
o <- opal.login()
opal.logout(o)

# login using options and personal access token
options(opal.token = 'HYG16LO0VaX4O0UardNbiqmr2ByBpRke',
        opal.url = 'https://opal-demo.obiba.org')
o <- opal.login()
opal.logout(o)

# login using ssl key pair
options(opal.opts = list(
          sslcert = 'my-publickey.pem',
          sslkey = 'my-privatekey.pem'))
o <- opal.login(url = 'https://opal-demo.obiba.org')
opal.logout(o)

# login with a R server profile
o <- opal.login(username = 'administrator', password = 'password', 
                url = 'https://opal-demo.obiba.org', profile = 'default')
opal.logout(o)
}
}
\seealso{
Other connection functions: 
\code{\link{opal.logout}()},
\code{\link{opal.profiles}()}
}
\concept{connection functions}
