% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.users.R
\name{oadmin.user_profile_delete}
\alias{oadmin.user_profile_delete}
\title{Delete a user profile}
\usage{
oadmin.user_profile_delete(opal, name)
}
\arguments{
\item{opal}{Opal object.}

\item{name}{User name}
}
\description{
Delete a user profile without deleting user if this one is defined in the Opal internal users registry.
Fails silently if user profile does not exist.
A user profile is the footprint of a user, created at first login. It keeps track of its activity, the realm
from which he/she was authenticated, its groups at time of the last login and more.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
pwd <- oadmin.user_add(o, "foo", groups = c("datashield", "CNSIM"))
oadmin.user_profile_delete(o, "foo")
opal.logout(o)
}
}
\seealso{
Other user functions: 
\code{\link{oadmin.user_add}()},
\code{\link{oadmin.user_delete}()},
\code{\link{oadmin.user_enable}()},
\code{\link{oadmin.user_exists}()},
\code{\link{oadmin.user_profiles}()},
\code{\link{oadmin.user_reset_password}()},
\code{\link{oadmin.users}()}
}
\concept{user functions}
