% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.table.R
\name{opal.table_perm}
\alias{opal.table_perm}
\title{Get the permissions on a table}
\usage{
opal.table_perm(opal, project, table)
}
\arguments{
\item{opal}{Opal connection object.}

\item{project}{Project name where the table will be located.}

\item{table}{Destination table name.}
}
\value{
A data.frame with columns: subject, type, permission
}
\description{
Get the permissions that were applied on a table.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
opal.table_perm_add(o, 'CNSIM', 'CNSIM1', c('andrei', 'valentina'), 'user', 'view')
opal.table_perm(o, 'CNSIM', 'CNSIM1')
opal.table_perm_delete(o, 'CNSIM', 'CNSIM1', c('andrei', 'valentina'), 'user')
opal.logout(o)
}
}
