% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.taxonomy.r
\name{opal.vocabularies}
\alias{opal.vocabularies}
\title{Get the vocabularies of a taxonomy}
\usage{
opal.vocabularies(opal, taxonomy, locale = "en", df = TRUE)
}
\arguments{
\item{opal}{Opal object.}

\item{taxonomy}{Name of the taxonomy}

\item{locale}{The language for labels (default is "en").}

\item{df}{Return a data.frame (default is TRUE)}
}
\description{
Get all the vocabularies of a taxonomy. A vocabulary describes the possible values of variable annotations.
}
\examples{
\donttest{
o <- opal.login('administrator','password','https://opal-demo.obiba.org')
opal.vocabularies(o, 'Mlstr_area')
opal.logout(o)
}
}
\seealso{
Other taxonomy functions: \code{\link{opal.taxonomies}},
  \code{\link{opal.taxonomy}}, \code{\link{opal.terms}},
  \code{\link{opal.vocabulary}}
}
\concept{taxonomy functions}
