oospprint = function (...) UseMethod ("oospprint")
oospformat = function (...) UseMethod ("oospformat")
oospsummary = function (...) UseMethod ("oospsummary")
oospplot = function (...) UseMethod ("oospplot")
oosplines = function (...) UseMethod ("oosplines")
oosppredict = function (...) UseMethod ("oosppredict")
oospfitted = function (...) UseMethod ("oospfitted")
oospresiduals = function (...) UseMethod ("oospresiduals")
oospweights = function (...) UseMethod ("oospweights")
oospaslist = function (...) UseMethod ("oospaslist")
oospasdataframe = function (...) UseMethod ("oospasdataframe")

oospprint.default = function (...) print (..., oosp=FALSE)
oospformat.default = function (...) format (..., oosp=FALSE)
oospsummary.default = function (...) summary (..., oosp=FALSE)
oospplot.default = function (...) plot (..., oosp=FALSE)
oosplines.default = function (...) lines (..., oosp=FALSE)
oosppredict.default = function (...) predict (..., oosp=FALSE)
oospfitted.default = function (...) fitted (..., oosp=FALSE)
oospresiduals.default = function (...) residuals (..., oosp=FALSE)
oospweights.default = function (...) weights (..., oosp=FALSE)
oospaslist.default = function (...) residuals (..., oosp=FALSE)
oospasdataframe.default = function (...) weights (..., oosp=FALSE)

print.object = function (x, ..., oosp=TRUE) if (oosp) oospprint (x, ...) else NextMethod ()
format.object = function (x, ..., oosp=TRUE) if (oosp) oospformat (x, ...) else NextMethod ()
summary.object = function (object, ..., oosp=TRUE) if (oosp) oospsummary (object, ...) else NextMethod ()
plot.object = function (x, y, ..., oosp=TRUE)
{	if (oosp) if (missing (y) ) oospplot (x, ...) else oospplot (x, y, ...)
	else NextMethod ()
}
lines.object = function (x, ..., oosp=TRUE) if (oosp) oosplines (x, ...) else NextMethod ()
predict.object = function (object, ..., oosp=TRUE) if (oosp) oosppredict (object, ...) else NextMethod ()
fitted.object = function (object, ..., oosp=TRUE) if (oosp) oospfitted (object, ...) else NextMethod ()
residuals.object = function (object, ..., oosp=TRUE) if (oosp) oospresiduals (object, ...) else NextMethod ()
weights.object = function (object, ..., oosp=TRUE) if (oosp) oospweights (object, ...) else NextMethod ()
as.list.object = function (x, ..., oosp=TRUE) if (oosp) oospaslist (x, ...) else NextMethod ()
as.data.frame.object = function (x, row.names=NULL, optional=FALSE, ..., oosp=TRUE)
	if (oosp) oospasdataframe (x, row.names, optional, ...) else NextMethod ()

