% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhpp_functions.R
\name{loess_smoothing_KDE}
\alias{loess_smoothing_KDE}
\title{Get loess smoothing for the unnormalized Markov KDE}
\usage{
loess_smoothing_KDE(tree.discr, Edge.KDE)
}
\arguments{
\item{tree.discr}{simmap or phylo object. A discretized tree using the 'discr_Simmap' function.}

\item{Edge.KDE}{list. A list with the estimated unnormalized KDEs ($Maps.mean) for each edge.}
}
\value{
A list with the loess smoothing calculated for each edge.
}
\description{
Calculates loess smoothing for the unnormalized Markov KDE obtained from the 'estimate_edge_KDE_Markov_kernel_unnorm' function.
}
\examples{
data("hym_kde", "hym_tree")
# Get reference tree.
tree_discr <- discr_Simmap(hym_tree, res = 200)
# Get non-normalized and normalized edge KDE data.
Edge_KDE <- hym_kde$head
# Calculate smoothing of edge KDE data.
Edge_KDE$Maps.mean.loess <- suppressWarnings(loess_smoothing_KDE(tree_discr, Edge_KDE))
# Check smoothing of KDE data for normalized mean rates from an arbitrary branch.
Edge_KDE$Maps.mean.loess.norm[[5]]
# Check smoothing of KDE data for non-normalized mean rates from an arbitrary branch.
Edge_KDE$Maps.mean.loess[[5]]

}
\author{
Sergei Tarasov
}
