% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paramo_functions.R
\name{RAC_query}
\alias{RAC_query}
\title{Retrieve all characters under a given set of terms}
\usage{
RAC_query(char_info, ONT, terms)
}
\arguments{
\item{char_info}{data.frame. A data.frame with two columns: the first column with character IDs and the second column with ontology IDs.}

\item{ONT}{ontology_index object.}

\item{terms}{character. The set of terms to aggregate characters.}
}
\value{
A named list with character groups.
}
\description{
Returns a named list aggregating characters under a specified set of terms (e.g., body regions).
}
\examples{
data("HAO", "hym_annot")
char_info <- hym_annot[1:2]
# Query for three anatomical regions.
terms <- c("head", "mesosoma", "metasoma")
query <- RAC_query(char_info, HAO, terms)
query 

}
\author{
Sergei Tarasov
}
