% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{get_term_sim_mat}
\alias{get_term_sim_mat}
\title{Get term-term similarity matrix}
\usage{
get_term_sim_mat(ontology, information_content, method = "lin",
  row_terms = names(information_content),
  col_terms = names(information_content))
}
\arguments{
\item{ontology}{\code{ontology_index} object.}

\item{information_content}{Numeric vector of information contents of terms (named by term)}

\item{method}{Character value equalling either "lin" or "resnik" to use Lin or Resnik's expression for similarity of terms respectively.}

\item{row_terms}{Character vector of term IDs to appear as rows of result matrix.}

\item{col_terms}{Character vector of term IDs to appear as cols of result matrix.}
}
\value{
Numeric matrix of pairwise term similarities.
}
\description{
Get matrix of pairwise similarity of individual terms based on Lin's (default) or Resnik's information content-based expression.
}
\seealso{
\code{\link{get_sim_grid}} \code{\link{resnik}}, \code{\link{lin}}
}
