% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{get_ontology}
\alias{get_OBO}
\alias{get_ontology}
\title{Read ontology from OBO file into R}
\usage{
get_ontology(file, propagate_relationships = "is_a",
  extract_tags = "minimal")

get_OBO(file, propagate_relationships = "is_a", extract_tags = "minimal")
}
\arguments{
\item{file}{File path of OBO formatted file.}

\item{propagate_relationships}{Character vector of relations}

\item{extract_tags}{Character value: either "minimal" or "everything", determining whether to extract only the properties of terms which are required to run functions in the package - i.e. \code{"id", "name", "parents", "children"} and \code{"ancestors"} - or extract all properties provided in the file. Defaults to \code{"minimal"}.}
}
\value{
\code{ontology_index} object.
}
\description{
Read ontology from OBO file into R
}
\seealso{
\code{\link{get_relation_names}}
}

