% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{swap_out_alt_ids}
\alias{swap_out_alt_ids}
\title{Remove alternate/deprecated term IDs and swap for new ones}
\usage{
swap_out_alt_ids(ontology, terms, remove_dead = FALSE)
}
\arguments{
\item{ontology}{\code{ontology_index} object.}

\item{terms}{Character vector of ontological terms.}

\item{remove_dead}{Boolean to indicate whether to strip out terms which can't be found in the given ontology database argument}
}
\value{
A directed adjacency matrix of \code{terms} based on DAG structure of ontology, whereby each term is considered adjacent to it's MRCA in \code{terms}
}
\description{
Remove alternate/deprecated term IDs and swap for new ones
}
\examples{
data(hpo)
swap_out_alt_ids(hpo, c("HP:0001873"))
}

