% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_concept.R
\name{get_concept}
\alias{get_concept}
\title{Get a concept in an ontology}
\usage{
get_concept(
  table = NULL,
  ontology = NULL,
  per_class = FALSE,
  mappings = FALSE,
  regex = FALSE,
  external = FALSE
)
}
\arguments{
\item{table}{\code{\link[=character]{character(1)}}\cr a table containing all columns (a
subset of "id", "class", "label", "has_broader" and "has_source") of the
ontology that shall be filter by the values in those columns.}

\item{ontology}{\code{\link[=list]{ontology(1)}}\cr either a path where the ontology is
stored, or an already loaded ontology.}

\item{per_class}{\code{\link[=logical]{logical(1)}}\cr whether ot not to flatten the
ontology before matching \code{table} with the ontology, whereby
\code{table} would contain columns of the classes in the ontology. This can
be useful when concepts are unique only within their parent concepts, so
that unique identification is only possible when they are matched together.}

\item{mappings}{\code{\link[=logical]{logical(1)}}\cr whether or not to provide a table
that includes mappings. In this case, only unique items of the concepts in
\code{table} are included in the output table.}

\item{regex}{\code{\link[=logical]{logical(1)}}\cr if \code{regex = TRUE}, the columns
defined in \code{table} are filtered by \code{\link[stringr]{str_detect}}
on the column values (if you define several, they are combined with an AND
operator), otherwise a \code{\link[dplyr]{left_join}} on the ontology is
carried out.}

\item{external}{\code{\link[=logical]{logical(1)}}\cr whether or not to return merely
the table of external concepts.}
}
\value{
A table of a subset of the ontology according to the values in
\code{...}
}
\description{
Get a concept in an ontology
}
\examples{
ontoDir <- system.file("extdata", "crops.rds", package = "ontologics")
onto <- load_ontology(path = ontoDir)

# exact matches from a loaded ontology ...
get_concept(table = data.frame(label = "FODDER CROPS"), ontology = onto)

# ... or one stored on the harddisc, with mappings (none available here)
get_concept(table = data.frame(label = "FODDER CROPS"), ontology = ontoDir,
            mappings = TRUE)

# extract concepts based on regular expressions
get_concept(table = data.frame(label = "crop", id = ".03$"),
            regex = TRUE, ontology = ontoDir)
}
