% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/om_geo.R
\name{om_geo}
\alias{om_geo}
\title{Load OnMarg spatial data}
\usage{
om_geo(year, level, format)
}
\arguments{
\item{year}{Integer year of data to load}

\item{level}{The level of precision to load, this can be "DAUID", "CTUID", "CSDUID", "CCSUID", "CDUID", "CMAUID", "PHUUID", "LHINUID", or "LHIN_SRUID"}

\item{format}{The format for the geographic object, this can be "sf" or "sp"}
}
\value{
A sf or sp object containing the Marginalization Index and geographic boundaries for every geographic identifier
}
\description{
This function combines Public Health Ontario's Ontario Marginalization Index data with Statistics Canada's shape files to create an sf_object.  The sf_object can be used for mapping with packages such as ggplot, and for spatial analysis.
}
\details{
If a year or level is used that does not exist or is not implemented, an error message will be produced.
If the geometry file is unable to be downloaded, an error message will be produced.
}
\examples{
\dontrun{
DA_2016_geo <- om_geo(2016, "DAUID", "sf")
}
}
