% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{map_save_ram}
\alias{map_save_ram}
\title{Perform map using background objects with only selected markers. It saves ram memory during the procedure.
It is useful if dealing with many markers in total data set.}
\usage{
map_save_ram(
  input.seq,
  tol = 1e-04,
  verbose = FALSE,
  rm_unlinked = FALSE,
  phase_cores = 1,
  size = NULL,
  overlap = NULL,
  parallelization.type = "PSOCK",
  max.gap = FALSE
)
}
\arguments{
\item{input.seq}{object of class sequence}

\item{tol}{tolerance for the C routine, i.e., the value used to evaluate
convergence.}

\item{verbose}{If \code{TRUE}, print tracing information.}

\item{rm_unlinked}{When some pair of markers do not follow the linkage criteria, 
if \code{TRUE} one of the markers is removed and returns a vector with remaining 
marker numbers (useful for mds_onemap and map_avoid_unlinked functions).}

\item{phase_cores}{The number of parallel processes to use when estimating
the phase of a marker. (Should be no more than 4)}

\item{size}{The center size around which an optimum is to be searched}

\item{overlap}{The desired overlap between batches}

\item{parallelization.type}{one of the supported cluster types. This should 
be either PSOCK (default) or FORK.}

\item{max.gap}{the marker will be removed if it have gaps higher than this defined threshold in both sides}
}
\description{
Perform map using background objects with only selected markers. It saves ram memory during the procedure.
It is useful if dealing with many markers in total data set.
}
