% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pie_Chart.R
\name{pie_chart}
\alias{pie_chart}
\title{Create a pie chart}
\usage{
pie_chart(ratio_data, variable, column, color)
}
\arguments{
\item{ratio_data}{a dataframe object of percents. output from ra_table function}

\item{variable}{The metadata variable you are measuring, i.e. "Class"}

\item{column}{either "Increase", "Decrease", or "Significant_Changes"}

\item{color}{string denoting color for outline. use NA for no outline}
}
\description{
Creates a pie chart as ggplot2 object using the output from ra_table.
}
\examples{
c57_nos2KO_mouse_countDF <- assign_hierarchy(c57_nos2KO_mouse_countDF, TRUE, "KEGG")
\dontshow{c57_nos2KO_mouse_countDF <- c57_nos2KO_mouse_countDF[1:20,]}
t_test_df <- omu_summary(count_data = c57_nos2KO_mouse_countDF,
metadata = c57_nos2KO_mouse_metadata,
numerator = "Strep", denominator = "Mock", response_variable = "Metabolite",
Factor = "Treatment",
log_transform = TRUE, p_adjust = "BH", test_type = "welch")

fold_change_counts <- count_fold_changes(count_data = t_test_df,
column = "Class", sig_threshold = 0.05, keep_unknowns = FALSE)

ra_table <- ra_table(fc_data = fold_change_counts, variable = "Class")

pie_chart(ratio_data = ra_table, variable = "Class", column = "Decrease", color = "black")
}
