% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concepts.R
\name{ConceptsResource}
\alias{ConceptsResource}
\title{Concepts Resource}
\value{
A list containing the concept data.

A list containing the concept data with mappings.

A list with \code{concepts} and any \code{failures}.

A list of suggestions.

Related concepts with scores and analysis.

Relationships with summary.
}
\description{
R6 class providing access to concept operations.
}
\keyword{internal}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ConceptsResource-new}{\code{ConceptsResource$new()}}
\item \href{#method-ConceptsResource-get}{\code{ConceptsResource$get()}}
\item \href{#method-ConceptsResource-get_by_code}{\code{ConceptsResource$get_by_code()}}
\item \href{#method-ConceptsResource-batch}{\code{ConceptsResource$batch()}}
\item \href{#method-ConceptsResource-suggest}{\code{ConceptsResource$suggest()}}
\item \href{#method-ConceptsResource-related}{\code{ConceptsResource$related()}}
\item \href{#method-ConceptsResource-relationships}{\code{ConceptsResource$relationships()}}
\item \href{#method-ConceptsResource-print}{\code{ConceptsResource$print()}}
\item \href{#method-ConceptsResource-clone}{\code{ConceptsResource$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptsResource-new"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptsResource-new}{}}}
\subsection{Method \code{new()}}{
Create a new ConceptsResource.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptsResource$new(base_req)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{base_req}}{Base httr2 request object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptsResource-get"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptsResource-get}{}}}
\subsection{Method \code{get()}}{
Get a concept by ID.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptsResource$get(
  concept_id,
  include_relationships = FALSE,
  include_synonyms = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{concept_id}}{The OMOP concept ID.}

\item{\code{include_relationships}}{Include related concepts. Default \code{FALSE}.}

\item{\code{include_synonyms}}{Include concept synonyms. Default \code{FALSE}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptsResource-get_by_code"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptsResource-get_by_code}{}}}
\subsection{Method \code{get_by_code()}}{
Get a concept by vocabulary and code.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptsResource$get_by_code(vocabulary_id, concept_code)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{vocabulary_id}}{The vocabulary ID (e.g., "SNOMED", "ICD10CM").}

\item{\code{concept_code}}{The concept code within the vocabulary.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptsResource-batch"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptsResource-batch}{}}}
\subsection{Method \code{batch()}}{
Get multiple concepts by IDs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptsResource$batch(
  concept_ids,
  include_relationships = FALSE,
  include_synonyms = FALSE,
  include_mappings = FALSE,
  vocabulary_filter = NULL,
  standard_only = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{concept_ids}}{Vector of concept IDs (max 1000).}

\item{\code{include_relationships}}{Include related concepts. Default \code{FALSE}.}

\item{\code{include_synonyms}}{Include concept synonyms. Default \code{FALSE}.}

\item{\code{include_mappings}}{Include concept mappings. Default \code{FALSE}.}

\item{\code{vocabulary_filter}}{Filter results to specific vocabularies.}

\item{\code{standard_only}}{Only return standard concepts. Default \code{FALSE}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptsResource-suggest"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptsResource-suggest}{}}}
\subsection{Method \code{suggest()}}{
Get concept suggestions (autocomplete).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptsResource$suggest(query, vocabulary = NULL, domain = NULL, limit = 10)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{Search query (min 2 characters).}

\item{\code{vocabulary}}{Filter to specific vocabulary.}

\item{\code{domain}}{Filter to specific domain.}

\item{\code{limit}}{Maximum suggestions (default 10, max 50).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptsResource-related"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptsResource-related}{}}}
\subsection{Method \code{related()}}{
Get related concepts.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptsResource$related(
  concept_id,
  relatedness_types = NULL,
  vocabulary_ids = NULL,
  domain_ids = NULL,
  min_relatedness_score = NULL,
  max_results = 50,
  include_scores = TRUE,
  standard_concepts_only = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{concept_id}}{The source concept ID.}

\item{\code{relatedness_types}}{Types of relatedness (hierarchical, semantic, etc.).}

\item{\code{vocabulary_ids}}{Filter to specific vocabularies.}

\item{\code{domain_ids}}{Filter to specific domains.}

\item{\code{min_relatedness_score}}{Minimum relatedness score.}

\item{\code{max_results}}{Maximum results (default 50, max 200).}

\item{\code{include_scores}}{Include score breakdown. Default \code{TRUE}.}

\item{\code{standard_concepts_only}}{Only return standard concepts. Default \code{FALSE}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptsResource-relationships"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptsResource-relationships}{}}}
\subsection{Method \code{relationships()}}{
Get concept relationships.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptsResource$relationships(
  concept_id,
  relationship_type = NULL,
  target_vocabulary = NULL,
  include_invalid = FALSE,
  page = 1,
  page_size = 20
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{concept_id}}{The concept ID.}

\item{\code{relationship_type}}{Filter by relationship type.}

\item{\code{target_vocabulary}}{Filter by target vocabulary.}

\item{\code{include_invalid}}{Include invalid relationships. Default \code{FALSE}.}

\item{\code{page}}{Page number. Default 1.}

\item{\code{page_size}}{Items per page. Default 20.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptsResource-print"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptsResource-print}{}}}
\subsection{Method \code{print()}}{
Print resource information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptsResource$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptsResource-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptsResource-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptsResource$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
