#' Chicken Genotype Data
#'
#' This file is a matrix of genotypes from 96 chickens encompassing 5 breeds,
#' genotyped as part of the Synbreed Project. Individuals are in rows. Marker genotypes
#' are in columns, coded as 0, 1, and 2. Row names are a breed index so all rows named "1"
#' are from breed 1, all rows named "2" are from breed 2, and so on. Column names are
#' marker names. These data are a subset of the data used by Beissinger et al. (2016).
#' The full dataset is hosted on Figshare at the which can be at the 
#' link below.
#' 
#' @docType data
#' 
#' @usage data(beissinger_data)
#' 
#' @format A matrix with 1417 rows and 100 columns.
#' 
#' @references Beissinger et al. (2016) Heredity.
#' (https://www.nature.com/articles/hdy201581)
#' 
#' @source (https://figshare.com/articles/Synbreed_Biodiversity_Panel_Genotypes/1497961)
"beissinger_data"
