% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting_properties.R
\name{fp_tab}
\alias{fp_tab}
\title{Tabulation mark properties object}
\usage{
fp_tab(pos, style = "decimal")
}
\arguments{
\item{pos}{Specifies the position of the tab stop (in inches).}

\item{style}{style of the tab. Possible values are:
"decimal", "left", "right" or "center".}
}
\description{
create a tabulation mark properties setting object for Word
or RTF. Results can be used as arguments of \code{\link[=fp_tabs]{fp_tabs()}}.

Once tabulation marks settings are defined, tabulation marks can
be added with \code{\link[=run_tab]{run_tab()}} inside a call to \code{\link[=fpar]{fpar()}} or
with \verb{\\t} within 'flextable' content.
}
\examples{
fp_tab(pos = 0.4, style = "decimal")
fp_tab(pos = 1, style = "right")
}
\seealso{
Other functions for defining formatting properties: 
\code{\link{fp_border}()},
\code{\link{fp_cell}()},
\code{\link{fp_par}()},
\code{\link{fp_tabs}()},
\code{\link{fp_text}()}
}
\concept{functions for defining formatting properties}
