% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_add.R
\name{body_add_caption}
\alias{body_add_caption}
\title{Add Word caption in a 'Word' document}
\usage{
body_add_caption(x, value, pos = "after")
}
\arguments{
\item{x}{an rdocx object}

\item{value}{an object returned by \code{\link[=block_caption]{block_caption()}}}

\item{pos}{where to add the new element relative to the cursor,
one of "after", "before", "on".}
}
\description{
Add a Word caption into an rdocx object.
}
\examples{
doc <- read_docx()

if (capabilities(what = "png")) {
  doc <- body_add_plot(doc,
    value = plot_instr(
      code = {
        barplot(1:5, col = 2:6)
      }
    ),
    style = "centered"
  )
}
run_num <- run_autonum(
  seq_id = "fig", pre_label = "Figure ",
  bkm = "barplot"
)
caption <- block_caption("a barplot",
  style = "Normal",
  autonum = run_num
)
doc <- body_add_caption(doc, caption)
print(doc, target = tempfile(fileext = ".docx"))
}
\seealso{
Other functions for adding content: 
\code{\link{body_add_blocks}()},
\code{\link{body_add_break}()},
\code{\link{body_add_docx}()},
\code{\link{body_add_fpar}()},
\code{\link{body_add_gg}()},
\code{\link{body_add_img}()},
\code{\link{body_add_par}()},
\code{\link{body_add_plot}()},
\code{\link{body_add_table}()},
\code{\link{body_add_toc}()},
\code{\link{body_append_start_context}()}
}
\concept{functions for adding content}
