% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_add.R
\name{body_add_fpar}
\alias{body_add_fpar}
\title{add fpar}
\usage{
body_add_fpar(x, value, style = NULL, pos = "after")
}
\arguments{
\item{x}{a docx device}

\item{value}{a character}

\item{style}{paragraph style}

\item{pos}{where to add the new element relative to the cursor,
one of "after", "before", "on".}
}
\description{
add an \code{fpar} (a formatted paragraph) into an rdocx object
}
\examples{
library(magrittr)
bold_face <- shortcuts$fp_bold(font.size = 30)
bold_redface <- update(bold_face, color = "red")
fpar_ <- fpar(ftext("Hello ", prop = bold_face),
              ftext("World", prop = bold_redface ),
              ftext(", how are you?", prop = bold_face ) )
doc <- read_docx() \%>\% body_add_fpar(fpar_)

print(doc, target = tempfile(fileext = ".docx"))

# a way of using fpar to center an image in a Word doc ----
rlogo <- file.path( R.home("doc"), "html", "logo.jpg" )
img_in_par <- fpar(
  external_img(src = rlogo, height = 1.06/2, width = 1.39/2),
  fp_p = fp_par(text.align = "center") )

read_docx() \%>\% body_add_fpar(img_in_par) \%>\%
  print(target = tempfile(fileext = ".docx") )

}
\seealso{
\code{\link{fpar}}
}
