% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_docx.R
\name{read_docx}
\alias{read_docx}
\alias{print.rdocx}
\title{Create a 'Word' document object}
\usage{
read_docx(path = NULL)

\method{print}{rdocx}(x, target = NULL, ...)
}
\arguments{
\item{path}{path to the docx file to use as base document.}

\item{x}{an rdocx object}

\item{target}{path to the docx file to write}

\item{...}{unused}
}
\description{
read and import a docx file as an R object
representing the document. When no file is specified, it
uses a default empty file.

Use then this object to add content to it and create Word files
from R.
}
\section{styles}{


\code{read_docx()} uses a Word file as the initial document.
This is the original Word document from which the document
layout, paragraph styles, or table styles come.

You will be able to add formatted text, change the paragraph
style with the R api, but it will always be easier to use
the styles from the original document.

See \verb{body_add_*} functions to add content.
}

\examples{
# create an rdocx object with default template ---
read_docx()

print(read_docx())
# write a rdocx object in a docx file ----
if( require(magrittr) ){
  read_docx() \%>\% print(target = tempfile(fileext = ".docx"))
}

}
\seealso{
\link{print.rdocx}, \link{body_add_par}, \link{body_add}
}
