% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppt_ph_with.R, R/ppt_ph_with_at.R
\name{ph_with_table}
\alias{ph_with_table}
\alias{ph_with_table_at}
\title{add table}
\usage{
ph_with_table(x, value, type = "body", index = 1, header = TRUE,
  first_row = TRUE, first_column = FALSE, last_row = FALSE,
  last_column = FALSE)

ph_with_table_at(x, value, left, top, width, height, header = TRUE,
  first_row = TRUE, first_column = FALSE, last_row = FALSE,
  last_column = FALSE)
}
\arguments{
\item{x}{a pptx device}

\item{value}{data.frame}

\item{type}{placeholder type}

\item{index}{placeholder index (integer). This is to be used when a placeholder type
is not unique in the current slide, e.g. two placeholders with type 'body'.}

\item{header}{display header if TRUE}

\item{first_row, last_row, first_column, last_column}{logical for PowerPoint table options}

\item{left, top}{location of the new shape on the slide}

\item{width, height}{shape size in inches}
}
\description{
add a table as a new shape in the current slide.
}
\examples{
library(magrittr)

doc <- read_pptx() \%>\%
  add_slide(layout = "Title and Content", master = "Office Theme") \%>\%
  ph_with_table(value = mtcars[1:6,], type = "body",
    last_row = FALSE, last_column = FALSE, first_row = TRUE)

print(doc, target = "ph_with_table.pptx")

library(magrittr)

doc <- read_pptx() \%>\%
  add_slide(layout = "Title and Content", master = "Office Theme") \%>\%
  ph_with_table_at(value = mtcars[1:6,],
    height = 4, width = 8, left = 4, top = 4,
    last_row = FALSE, last_column = FALSE, first_row = TRUE)

print(doc, target = "ph_with_table2.pptx")
}
