% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_add_chunk.R
\name{slip_in_seqfield}
\alias{slip_in_seqfield}
\title{append seq field}
\usage{
slip_in_seqfield(x, str, style = NULL, pos = "after")
}
\arguments{
\item{x}{an rdocx object}

\item{str}{seq field value}

\item{style}{text style}

\item{pos}{where to add the new element relative to the cursor,
"after" or "before".}
}
\description{
append seq field into a paragraph of an rdocx object
}
\examples{
library(magrittr)
x <- read_docx() \%>\%
  body_add_par("Time is: ", style = "Normal") \%>\%
  slip_in_seqfield(
    str = "TIME \\u005C@ \\"HH:mm:ss\\" \\u005C* MERGEFORMAT",
    style = 'strong') \%>\%

  body_add_par(" - This is a figure title", style = "centered") \%>\%
  slip_in_seqfield(str = "SEQ Figure \\u005C* roman",
    style = 'Default Paragraph Font', pos = "before") \%>\%
  slip_in_text("Figure: ", style = "strong", pos = "before") \%>\%

  body_add_par(" - This is another figure title", style = "centered") \%>\%
  slip_in_seqfield(str = "SEQ Figure \\u005C* roman",
    style = 'strong', pos = "before")  \%>\%
  slip_in_text("Figure: ", style = "strong", pos = "before") \%>\%
  body_add_par("This is a symbol: ", style = "Normal") \%>\%
  slip_in_seqfield(str = "SYMBOL 100 \\u005Cf Wingdings",
    style = 'strong')

print(x, target = "seqfield.docx")
}
