% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify_pptx.R
\name{media_extract}
\alias{media_extract}
\title{Extract media from a document object}
\usage{
media_extract(x, path, target)
}
\arguments{
\item{x}{an rpptx object or an rdocx object}

\item{path}{media path, should be a relative path}

\item{target}{target file}
}
\description{
Extract files from an \code{rdocx} or \code{rpptx} object.
}
\examples{
example_pptx <- system.file(package = "officer",
  "doc_examples/example.pptx")
doc <- read_pptx(example_pptx)
content <- pptx_summary(doc)
image_row <- content[content$content_type \%in\% "image", ]
media_file <- image_row$media_file
media_extract(doc, path = media_file, target = "extract.png")
}
