% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argument_validation.R
\name{match_arg}
\alias{match_arg}
\title{Argument matching}
\usage{
match_arg(arg, choices, several.ok = FALSE, none.ok = FALSE)
}
\arguments{
\item{arg}{A \code{character} (vector), the function argument.}

\item{choices}{A \code{character} (vector) of allowed values for \code{arg}.}

\item{several.ok}{Either \code{TRUE} if \code{arg} is allowed to have more than one element,
or \code{FALSE} else.}

\item{none.ok}{Either \code{TRUE} if \code{arg} is allowed to have zero elements,
or \code{FALSE} else.}
}
\value{
The un-abbreviated version of the exact or unique partial match if there is
one. Otherwise, an error is signaled if \code{several.ok} is \code{FALSE}
or \code{none.ok} is \code{FALSE}.
When \code{several.ok} is \code{TRUE} and (at least) one element of
\code{arg} has a match, all un-abbreviated versions of matches are returned.
When \code{none.ok} is \code{TRUE} and \code{arg} has zero elements,
\code{character(0)} is returned.
}
\description{
This function matches function arguments and is a modified version of
\code{\link[base]{match.arg}}.
}
