% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getdata_batch.R
\name{getdata_batch}
\alias{getdata_batch}
\title{Convenient wrapper for getdata}
\usage{
getdata_batch(origin, destination, initial_year, final_year, classification, by)
}
\arguments{
\item{origin}{ISO code for country of origin (e.g. \code{chl} for Chile). 
Run \code{country_codes} in case of doubt.}

\item{destination}{ISO code for country of destination (e.g. \code{chn} for China). 
Run \code{country_codes} in case of doubt.}

\item{initial_year}{Numeric value greater or equal to 1962 and lower of equal to 2016. 
This needs to be lower or equal to \code{final_year}.}

\item{final_year}{Numeric value greater or equal to 1962 and lower of equal to 2016. 
This needs to be greater or equal to \code{initial_year}.}

\item{classification}{Any of the available trade classifications in the OEC (\code{sitc}, \code{hs92}, 
\code{hs96}, \code{hs02} or \code{hs07}). Default set to \code{sitc}.}

\item{by}{Numeric value to define the increment of the sequence of years. Default set to \code{1}.}
}
\description{
Returns a tibble containing imports, exports and relevant metrics 
    (e.g. exports growth w/r to last year) for a range of years as the result of different API calls 
    and data transforming. 
    The API returns data for different trade classifications: 
    (i) SITC (1962-2016); (ii) HS92 (1992-2016); (iii) HS96 (1996-2016); (iv) HS02 (2002-2016); 
    (v) HS07 (2007-2016).
}
\examples{
\dontrun{
# The next examples can take more than 5 seconds to compute, and specially for large economies so 
# these are just shown without evaluation according to CRAN rules

# Run `country_codes` to display the full table of countries

# What does Chile export to China?  
# years 2010 to 2015 - SITC (4 characters)
getdata_batch("chl", "chn", 2010, 2015)
# or with explicit parameters
getdata_batch("chl", "chn", 2010, 2015, "sitc", 1)

# What does Chile export to China?  
# years 2010 to 2015 - HS07 (4 and 6 characters)
getdata_batch("chl", "chn", 2010, 2015, "hs07")

# What does Chile export to China?  
# years 2010 and 2012 - HS07 (4 and 6 characters)
getdata_batch("chl", "chn", 2010, 2012, "hs07", 2)
}
}
\seealso{
\code{getdata}
}
\keyword{functions}
