% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toa_sports.R
\name{toa_sports}
\alias{toa_sports}
\title{\strong{Find sports for which odds are accessible through the Odds API}}
\usage{
toa_sports(all_sports = TRUE)
}
\arguments{
\item{all_sports}{(\emph{Logical} required): If true, returns all sports and if false, returns only active sports. Defaults to true.}
}
\value{
Sports for which The Odds API provides betting information for as a tibble:\tabular{ll}{
   col_name \tab types \cr
   key \tab character \cr
   group \tab character \cr
   title \tab character \cr
   description \tab character \cr
   active \tab logical \cr
   has_outrights \tab logical \cr
}
}
\description{
\strong{Get the Sports for which the Odds API provides coverage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ toa_sports(all_sports=TRUE)
}\if{html}{\out{</div>}}
}
\examples{
\donttest{
  try(toa_sports(all_sports = TRUE))
}

}
\keyword{Betting}
\keyword{Lines}
