% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{od_disaggregate}
\alias{od_disaggregate}
\alias{od_split}
\title{Split-up each OD pair into multiple OD pairs based on subpoints/subzones}
\usage{
od_disaggregate(
  od,
  z,
  subzones = NULL,
  subpoints = NULL,
  code_append = "_ag",
  population_column = 3,
  population_per_od = 50,
  keep_ids = TRUE,
  integer_outputs = FALSE
)

od_split(
  od,
  z,
  subzones = NULL,
  subpoints = NULL,
  code_append = "_ag",
  population_column = 3,
  population_per_od = 50,
  keep_ids = TRUE,
  integer_outputs = FALSE
)
}
\arguments{
\item{od}{An origin-destination data frame}

\item{z}{Zones representing origins and destinations}

\item{subzones}{Sub-zones within the zones defining the OD data}

\item{subpoints}{Points within the zones defining the OD data start/end points}

\item{code_append}{The name of the column containing aggregate zone names}

\item{population_column}{The column containing the total population (if it exists)}

\item{population_per_od}{Maximum flow in the population_column to assign per OD pair.
This only comes into effect if there are enough subpoints to choose from.}

\item{keep_ids}{Should the origin and destination ids be kept?
\code{TRUE} by default, meaning 2 extra columns are appended, with the
names \code{o_agg} and \code{d_agg} containing IDs from the original OD data.}

\item{integer_outputs}{Should integer outputs be returned? \code{FALSE} by default.
Note: there is a known issue when integer results are generated. See
https://github.com/ITSLeeds/od/issues/31 for details.}
}
\description{
This function is for splitting-up OD pairs.
It increases the number of rows in an OD dataset, while aiming
to keep the amount of travel represented in the data the same.
To take an analogy from another package, it's roughly equivalent
to \href{https://tidyr.tidyverse.org/reference/pivot_longer.html}{\code{tidyr::pivot_longer()}}.
}
\details{
An alias for the function is \code{od_split()}.
}
\examples{
od = od_data_df[1:2, ]
od
zones = od::od_data_zones_min
od_sf = od_to_sf(od, zones)
od_disag = od_disaggregate(od, zones)
od_disag2 = od_disaggregate(od, zones, population_per_od = 200)
plot(zones$geometry)
plot(od_sf$geometry, lwd = 9, add = TRUE)
plot(od_disag$geometry, col = "grey", lwd = 1, add = TRUE)
plot(od_disag2$geometry, lwd = 1, add = TRUE)
table(od_disag$o_agg, od_disag$d_agg)
subzones = od_data_zones_small
od_disag = od_disaggregate(od, zones, subzones)
ncol(od_disag) -3 == ncol(od) # same number of columns
# (except disag data gained geometry and new agg ids)
sum(od_disag[[3]]) == sum(od[[3]])
sum(od_disag[[4]]) == sum(od[[4]])
# integer results
od_disag_integer = od_disaggregate(od, zones, subzones)
plot(rowSums(sf::st_drop_geometry(od_disag)[4:10]), od_disag[[3]])
plot(od_data_zones_small$geometry)
plot(od_data_zones_min$geometry, lwd = 3, col = NULL, add = TRUE)
plot(od_sf["all"], add = TRUE)
plot(od_disag["all"], add = TRUE)

# with buildings data
od_disag_buildings = od_disaggregate(od, zones, od_data_buildings)
summary(od_disag_buildings)
plot(od_disag_buildings)
}
