% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od-funs.R
\name{od_to_sf}
\alias{od_to_sf}
\alias{od_to_sfc}
\title{Convert OD data into geographic 'desire line' objects}
\usage{
od_to_sf(
  x,
  z,
  zd = NULL,
  silent = FALSE,
  filter = TRUE,
  package = "sfheaders",
  crs = 4326
)

od_to_sfc(
  x,
  z,
  zd = NULL,
  silent = TRUE,
  package = "sfheaders",
  crs = 4326,
  filter = TRUE
)
}
\arguments{
\item{x}{A data frame in which the first two columns are codes
representing points/zones of origin and destination}

\item{z}{Zones representing origins and destinations}

\item{zd}{Zones representing destinations}

\item{silent}{Hide messages? \code{FALSE} by default.}

\item{filter}{Remove rows with no matches in \code{z}? \code{TRUE} by default}

\item{package}{Which package to use to create the sf object? \code{sfheaders} is the default.}

\item{crs}{The coordinate reference system of the output, if not known in \code{z}.
4326 by default.}
}
\description{
Convert OD data into geographic 'desire line' objects
}
\examples{
x = od_data_df
z = od_data_zones
desire_lines = od_to_sf(x, z)
desire_lines[1:3]
}
