% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/largeur_fleche.R
\name{largeur_fleche}
\alias{largeur_fleche}
\title{Width of the arrow for 'leaflet' maps}
\usage{
largeur_fleche(map)
}
\arguments{
\item{map}{objet leaflet.}
}
\value{
Retourne une valeur numerique.
}
\description{
Width of the largest arrow of the map in kilometers for 'leaflet' maps.
}
\details{
La largeur de la fleche est disponible uniquement pour les representations
de fleches joignantes et de fleches saphirs.
}
\examples{

data("donnees_biloc")
data("regm")

# Fleches joignantes
map <- leaflet_joignantes(data = donnees_biloc, fondMaille = regm, typeMaille = "REG",
idDataDepart = "REG_DEPART", idDataArrivee = "REG_ARRIVEE",
varFlux = "MIGR", filtreDist = 1000, filtreMajeurs = 3)
\donttest{
 map
}
largeur_fleche(map)
# [1] 100

# Fleches joignantes
map <- leaflet_joignantes(data = donnees_biloc, fondMaille = regm, typeMaille = "REG",
idDataDepart = "REG_DEPART", idDataArrivee = "REG_ARRIVEE",
varFlux = "MIGR", largeurFlecheMax = 200, filtreDist = 1000,
filtreMajeurs = 3)
\donttest{
 map
}
largeur_fleche(map)
# [1] 200

}
\seealso{
\code{\link{leaflet_joignantes} \link{leaflet_saphirs}}
}
\keyword{documentation}
