% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_module.R
\name{plot_ui}
\alias{plot_ui}
\alias{plot_server}
\title{NOAA plot module}
\usage{
plot_ui(id)

plot_server(id, NOAA, points)
}
\arguments{
\item{id}{Namespace id shiny module.}

\item{NOAA}{Reactive value for the dataset containing the locations
coordinates.}

\item{points}{Add locations of extracted point geometry.}
}
\value{
Shiny module.
}
\description{
This shiny module (\code{plot_ui()} + \code{plot_server()}) visualizes the loaded
data according to the selected epsg projection (\code{"original"}, \code{"4326"},
\code{"3031"}, or \code{"3995"}). In addition it provides an interactive plot
interface to select location for data extraction based on a single-click.
}
\examples{

# run plot module stand-alone
if (curl::has_internet() && interactive()) {

library(oceanexplorer)
library(shiny)

# data
NOAA <- get_NOAA("oxygen", 1, "annual")

# coordinates
points <- filter_NOAA(NOAA, 1, list(lon = c(-160, -120), lat =  c(11, 12)))

# gui
ui <- fluidPage(plot_ui("plot"))

# server
server <-function(input, output, session) {
 plot_server("plot", reactive(NOAA), reactive(points))
}

# run app
shinyApp(ui, server)

}
}
