/* vim: set expandtab shiftwidth=2 softtabstop=2 tw=70: */

#include <Rcpp.h>
using namespace Rcpp;

// Cross-reference work:
// 1. update ../src/registerDynamicSymbol.c with an item for this
// 2. main code should use the autogenerated wrapper in ../R/RcppExports.R
//
// [[Rcpp::export]]
IntegerVector do_gappy_index(IntegerVector starts, IntegerVector offset, IntegerVector length)
{
    long int nstarts = starts.size();
    long int n = nstarts * length[0];
    long int k = 0;
    IntegerVector res(n);
    if (nstarts > 0) {
      long int minspan = 100 * nstarts * length[0]; // start large
      for (long int i = 1; i < nstarts; i++) {
        long int span = starts[i] - starts[i-1];
        if (span < minspan)
          minspan = span;
      }
      if (length[0] > minspan)
        ::Rf_error("'length' %d exceeds minimum span between 'starts' elements (%ld)", length[0], minspan);
    }
    for (long int i = 0; i < nstarts; i++) {
      long int off = offset[0];
      for (long int j = 0; j < length[0]; j++) {
        res[k++] = starts[i] + off;
        off++;
        if (k > n) {
          break;
        }
      }
    }
    return res;
}

