% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sw.R
\name{swThermalConductivity}
\alias{swThermalConductivity}
\title{Seawater Thermal Conductivity}
\usage{
swThermalConductivity(salinity, temperature = NULL, pressure = NULL)
}
\arguments{
\item{salinity}{salinity (PSU), or a \code{ctd} object, in which case
\code{temperature} and \code{pressure} will be ignored.}

\item{temperature}{\emph{in-situ} temperature (\eqn{^\circ}{deg}C), defined
on the ITS-90 scale; see \dQuote{Temperature units} in the documentation for
\code{\link[=swRho]{swRho()}}.}

\item{pressure}{pressure (dbar)}
}
\value{
Conductivity of seawater in \eqn{W m^{-1} {^\circ} C^{-1}}{W/(m*degC)}.
To calculate thermal diffusivity in \eqn{m^2/s^2}, divide by the
product of density and specific heat, as in the example.
}
\description{
Compute seawater thermal conductivity, in \eqn{W
m^{-1\circ}C^{-1}}{W/(m*degC)}
}
\details{
Caldwell's (1974) detailed formulation is used.  To be specific, his
equation 6 to calculate K, and his two sentences above that equation are
used to infer this to be K(0,T,S) in his notation of equation 7. Then,
application of his equations 7 and 8 is straightforward. He states an
accuracy for this method of 0.3 percent.  (See the check against his Table 1
in the \dQuote{Examples}.)
}
\examples{
library(oce)
# Values in m^2/s, a unit that is often used instead of W/(m*degC).
swThermalConductivity(35, 10, 100) / (swRho(35, 10, 100) * swSpecificHeat(35, 10, 100)) # ocean
swThermalConductivity(0, 20, 0) / (swRho(0, 20, 0) * swSpecificHeat(0, 20, 0)) # lab
# Caldwell Table 1 gives 1478e-6 cal/(cm*sec*degC) at 31.5 o/oo, 10degC, 1kbar
joulePerCalorie <- 4.18400
cmPerM <- 100
swThermalConductivity(31.5, 10, 1000) / joulePerCalorie / cmPerM

}
\references{
Caldwell, Douglas R., 1974. Thermal conductivity of seawater,
\emph{Deep-sea Research}, \emph{21}, 131-137.
}
\seealso{
Other functions that calculate seawater properties: 
\code{\link{T68fromT90}()},
\code{\link{T90fromT48}()},
\code{\link{T90fromT68}()},
\code{\link{computableWaterProperties}()},
\code{\link{locationForGsw}()},
\code{\link{swAbsoluteSalinity}()},
\code{\link{swAlphaOverBeta}()},
\code{\link{swAlpha}()},
\code{\link{swBeta}()},
\code{\link{swCSTp}()},
\code{\link{swConservativeTemperature}()},
\code{\link{swDepth}()},
\code{\link{swDynamicHeight}()},
\code{\link{swLapseRate}()},
\code{\link{swN2}()},
\code{\link{swPressure}()},
\code{\link{swRho}()},
\code{\link{swRrho}()},
\code{\link{swSCTp}()},
\code{\link{swSR}()},
\code{\link{swSTrho}()},
\code{\link{swSigma0}()},
\code{\link{swSigma1}()},
\code{\link{swSigma2}()},
\code{\link{swSigma3}()},
\code{\link{swSigma4}()},
\code{\link{swSigmaTheta}()},
\code{\link{swSigmaT}()},
\code{\link{swSigma}()},
\code{\link{swSoundAbsorption}()},
\code{\link{swSoundSpeed}()},
\code{\link{swSpecificHeat}()},
\code{\link{swSpice}()},
\code{\link{swSstar}()},
\code{\link{swTFreeze}()},
\code{\link{swTSrho}()},
\code{\link{swTheta}()},
\code{\link{swViscosity}()},
\code{\link{swZ}()}
}
\author{
Dan Kelley
}
\concept{functions that calculate seawater properties}
