% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R
\name{plot,oce-method}
\alias{plot,oce-method}
\alias{plot.oce}
\title{Plot an oce Object}
\usage{
\S4method{plot}{oce}(x, y, ...)
}
\arguments{
\item{x}{a basic \linkS4class{oce} object,
but not from any subclass that derive from this base, because
subclasses have their own plot methods, e.g. calling \code{plot()} on a
\linkS4class{ctd} object dispatches to \code{\link[=plot,ctd-method]{plot,ctd-method()}}.}

\item{y}{Ignored; only present here because S4 object for generic \code{plot}
need to have a second parameter before the \code{...} parameter.}

\item{...}{Passed to \code{\link[=hist]{hist()}}, \code{\link[=plot]{plot()}}, or to
\code{\link[=pairs]{pairs()}}, according to whichever does the plotting.}
}
\description{
This creates a \code{\link[=pairs]{pairs()}} plot of the elements in the \code{data}
slot, if there are more than 2 elements there, or a simple xy plot if 2
elements, or a histogram if 1 element.
}
\examples{
library(oce)
o <- new("oce")
o <- oceSetData(o, "x", rnorm(10))
o <- oceSetData(o, "y", rnorm(10))
o <- oceSetData(o, "z", rnorm(10))
plot(o)
}
