% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adp.nortek.ad2cp.R
\name{read.adp.ad2cp}
\alias{read.adp.ad2cp}
\title{Read a Nortek AD2CP File}
\usage{
read.adp.ad2cp(
  file,
  from = 1L,
  to = 0L,
  by = 1L,
  dataType = NULL,
  dataSet = 1L,
  tz = getOption("oceTz"),
  longitude = NA,
  latitude = NA,
  plan,
  TOC = FALSE,
  debug = getOption("oceDebug"),
  orientation,
  distance,
  monitor,
  despike,
  ...
)
}
\arguments{
\item{file}{a connection or a character string giving the name of the file to
load.}

\item{from}{an integer indicating the index number of the first record to
read. This must equal 1, for this version of \code{read.adp.ad2cp}.  (If not
provided, \code{from} defaults to 1.)}

\item{to}{an integer indicating the final record to read. If \code{to} is 0L,
which is the default, then the value is changed internally to 1e9, and
reading stops at the end of the file.}

\item{by}{ignored.}

\item{dataType}{an indication of the data type to be extracted.  If this is
NULL (the default) then \code{read.adp.ad2cp()} returns a data frame indicating
the data type occurrence rate in the file.  Otherwise, \code{dataType} must be
either a numeric or character value (see \dQuote{Details}).  In the numeric
case, which includes both base-10 numbers and \code{raw} values, \code{dataType} is
converted to an integer that is taken to indicate the data type via ID. The
permitted values follow the Nortek convention, a summary of which is shown
the table at the start of the \dQuote{Details} section.  In the character
case, it must be a string taken from that same table.}

\item{dataSet}{a positive integer that indicates which of the possibly
several data sets stored within a file is to be focussed upon.  By
default, the first data set is chosen. Note that data sets are found
by trying to match each text data chunk against the regular expression
\code{"^GETCLOCKSTR,TIME="}.}

\item{tz}{a character value indicating time zone. This is used in
interpreting times stored in the file.}

\item{longitude, latitude}{numerical values indicating the observation
location.}

\item{plan}{optional integer specifying which 'plan' to focus on (see}

\item{TOC}{a logical value.  If this is FALSE (the default) then
the other parameters of the function are used to select data from
the indicated \code{filename}, and an \linkS4class{adp} object is returned.
However, if \code{TOC} is TRUE, then the number of datasets held within
the file is returned.}

\item{debug}{an integer value indicating the level of debugging.  Set to 1 to
get a moderate amount of debugging information, from the R code only, to 2 to
get some debugging information from the C++ code that is used to parse the
data chunks, or to 3 for intensive debugging at both levels.}

\item{orientation, distance, monitor, despike}{ignored, provided only for
calling compatibility with other functions that read \linkS4class{adp}
files.  A warning is issued if any of these is supplied in a call
to \code{read.adp.ad2cp()}.}

\item{\dots}{ignored parameters that might be passed to \code{read.adp.ad2cp()}
by \code{\link[=read.oce]{read.oce()}}.}
}
\value{
\code{read.adp.ad2cp()} returns either an \linkS4class{adp} object or
the number of data sets within the file, according to the value
of \code{TOC}.
}
\description{
This function is under active development and may change without notice.  In
contrast with other \code{oce} reading functions, \code{\link[=read.adp.ad2cp]{read.adp.ad2cp()}} focusses just
on one data type within the source file.  Another difference is that it can
either return an object holding the data or just a data frame holding a
description of the data types in the file; indeed, the latter is the default.
See \dQuote{Details} for more on the reasons for these departures from the
usual \code{oce} pattern.
}
\details{
Why does \code{\link[=read.adp.ad2cp]{read.adp.ad2cp()}} focus only on parts of the data file? The answer
lies in the AD2CP format itself, which may combine data subsets of such
differing natures as to break with the \code{oce} system of pairing a \code{metadata}
slot with a \code{data} slot.  For example, in a conventional ADP dataset, the
\code{metadata} slot has items for the sampling times, the number of beams, the
blanking distance, the cell size, the number of cells, etc.  Such items have
a natural pairing with elements of the \code{data} slot, and \code{oce} uses this
pairing in constructing plots and other items. However, an AD2CP file might
combine such data with echosounder measurements, and these will have
different values for number of beams and so forth.  This poses a challenge
in naming conventions within the \code{oce} object, with ripple effects for
plotting and data access.  Those ripple effects would extend beyond \code{oce}
itself to user code.  To avoid such problems, \code{\link[=read.adp.ad2cp]{read.adp.ad2cp()}}
is designed to focus on one data type at a time, relying on users to
keep track of the resultant object, perhaps to combine it with other objects
from within the AD2CP file or other files, in the normal R manner.

The permitted values for \code{dataType} are shown in the table below;
the \code{dataType} argument of \code{\link[=read.adp.ad2cp]{read.adp.ad2cp()}} may be chosen from any
of the three columns in this table.\tabular{rrr}{
   code (raw) \tab code (integer) \tab oce name \cr
   ---------- \tab -------------- \tab ----------------- \cr
   \code{0x15} \tab 21 \tab \code{burst} \cr
   \code{0x16} \tab 22 \tab \code{average} \cr
   \code{0x17} \tab 23 \tab \code{bottomTrack} \cr
   \code{0x18} \tab 24 \tab \code{interleavedBurst} \cr
   \code{0x1a} \tab 26 \tab \code{burstAltimeterRaw} \cr
   \code{0x1b} \tab 27 \tab \code{DVLBottomTrack} \cr
   \code{0x1c} \tab 28 \tab \code{echosounder} \cr
   \code{0x1d} \tab 29 \tab \code{DVLWaterTrack} \cr
   \code{0x1e} \tab 30 \tab \code{altimeter} \cr
   \code{0x1f} \tab 31 \tab \code{averageAltimeter} \cr
   \code{0x23} \tab 35 \tab \code{echosounderRaw} \cr
   \code{0xa0} \tab 160 \tab \code{text} \cr
}
}
\examples{
library(oce)
# You can run this within the oce directory, if you clone from github.
file <- "tests/testthat/local_data/ad2cp/S102791A002_Barrow_v2.ad2cp"
if (file.exists(file)) {
    library(oce)
    d <- read.oce(file)
}

}
\references{
Nortek AS. \dQuote{Signature Integration 55|250|500|1000kHz.} Nortek AS,
2017.

Nortek AS. \dQuote{Signature Integration 55|250|500|1000kHz.} Nortek AS,
2018.

Nortek AS. \dQuote{Signature Integration 55|250|500|1000kHz.} Nortek AS,
March 31, 2022.
}
\seealso{
Other things related to adp data: 
\code{\link{[[,adp-method}},
\code{\link{[[<-,adp-method}},
\code{\link{ad2cpCodeToName}()},
\code{\link{ad2cpHeaderValue}()},
\code{\link{adp-class}},
\code{\link{adpAd2cpFileTrim}()},
\code{\link{adpConvertRawToNumeric}()},
\code{\link{adpEnsembleAverage}()},
\code{\link{adpFlagPastBoundary}()},
\code{\link{adpRdiFileTrim}()},
\code{\link{adp_rdi.000}},
\code{\link{adp}},
\code{\link{applyMagneticDeclination,adp-method}},
\code{\link{as.adp}()},
\code{\link{beamName}()},
\code{\link{beamToXyzAdpAD2CP}()},
\code{\link{beamToXyzAdp}()},
\code{\link{beamToXyzAdv}()},
\code{\link{beamToXyz}()},
\code{\link{beamUnspreadAdp}()},
\code{\link{binmapAdp}()},
\code{\link{enuToOtherAdp}()},
\code{\link{enuToOther}()},
\code{\link{handleFlags,adp-method}},
\code{\link{is.ad2cp}()},
\code{\link{plot,adp-method}},
\code{\link{read.adp.nortek}()},
\code{\link{read.adp.rdi}()},
\code{\link{read.adp.sontek.serial}()},
\code{\link{read.adp.sontek}()},
\code{\link{read.adp}()},
\code{\link{read.aquadoppHR}()},
\code{\link{read.aquadoppProfiler}()},
\code{\link{read.aquadopp}()},
\code{\link{rotateAboutZ}()},
\code{\link{setFlags,adp-method}},
\code{\link{subset,adp-method}},
\code{\link{subtractBottomVelocity}()},
\code{\link{summary,adp-method}},
\code{\link{toEnuAdp}()},
\code{\link{toEnu}()},
\code{\link{velocityStatistics}()},
\code{\link{xyzToEnuAdpAD2CP}()},
\code{\link{xyzToEnuAdp}()},
\code{\link{xyzToEnu}()}

Other things related to ad2cp data: 
\code{\link{ad2cpCodeToName}()},
\code{\link{ad2cpHeaderValue}()},
\code{\link{adpAd2cpFileTrim}()},
\code{\link{is.ad2cp}()}

Other functions that read adp data: 
\code{\link{read.adp.nortek}()},
\code{\link{read.adp.rdi}()},
\code{\link{read.adp.sontek.serial}()},
\code{\link{read.adp.sontek}()},
\code{\link{read.adp}()},
\code{\link{read.aquadoppHR}()},
\code{\link{read.aquadoppProfiler}()},
\code{\link{read.aquadopp}()}
}
\author{
Dan Kelley
}
\concept{functions that read adp data}
\concept{things related to ad2cp data}
\concept{things related to adp data}
