% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctd.R
\name{ctdFindProfilesRBR}
\alias{ctdFindProfilesRBR}
\title{Find Profiles within a CTD object read from a RBR file}
\usage{
ctdFindProfilesRBR(
  x,
  direction = "descending",
  arr.ind = FALSE,
  debug = getOption("oceDebug")
)
}
\arguments{
\item{x}{either an \linkS4class{rsk} or a \linkS4class{ctd} object; in the former case,
it is converted to a \linkS4class{ctd} object with \code{\link[=as.ctd]{as.ctd()}}.}

\item{direction}{character value, either \code{"descending"} or \code{"ascending"},
indicating the sampling direction to be selected.  The default, \code{"descending"},
is the commonly preferred choice.}

\item{arr.ind}{logical value indicating whether the array indices should be
returned; the alternative is to return a vector of ctd objects.}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed. If one function calls another, it usually reduces the value of
\code{debug} first, so that a user can often obtain deeper debugging
by specifying higher \code{debug} values.}
}
\description{
This uses information about profiles that is contained within the \code{metadata}
slot of the first argument, \code{x}, having been inserted there by \code{\link[=read.rsk]{read.rsk()}}.
If \code{x} was created by reading an \code{.rsk} file with \code{\link[=read.rsk]{read.rsk()}},
and if that file contained geographical information (that is, if it had a
data table named \code{geodata}) then the \emph{first} longitude and latitude from each
profile is stored in the \code{metadata} slot of the returned value.
}
\seealso{
Other things related to ctd data: 
\code{\link{CTD_BCD2014666_008_1_DN.ODF.gz}},
\code{\link{[[,ctd-method}},
\code{\link{[[<-,ctd-method}},
\code{\link{as.ctd}()},
\code{\link{cnvName2oceName}()},
\code{\link{ctd-class}},
\code{\link{ctd.cnv.gz}},
\code{\link{ctdDecimate}()},
\code{\link{ctdFindProfiles}()},
\code{\link{ctdRaw}},
\code{\link{ctdRepair}()},
\code{\link{ctdTrim}()},
\code{\link{ctd_aml.csv.gz}},
\code{\link{ctd}},
\code{\link{d200321-001.ctd.gz}},
\code{\link{d201211_0011.cnv.gz}},
\code{\link{handleFlags,ctd-method}},
\code{\link{initialize,ctd-method}},
\code{\link{initializeFlagScheme,ctd-method}},
\code{\link{oceNames2whpNames}()},
\code{\link{oceUnits2whpUnits}()},
\code{\link{plot,ctd-method}},
\code{\link{plotProfile}()},
\code{\link{plotScan}()},
\code{\link{plotTS}()},
\code{\link{read.ctd.aml}()},
\code{\link{read.ctd.itp}()},
\code{\link{read.ctd.odf}()},
\code{\link{read.ctd.odv}()},
\code{\link{read.ctd.sbe}()},
\code{\link{read.ctd.ssda}()},
\code{\link{read.ctd.woce.other}()},
\code{\link{read.ctd.woce}()},
\code{\link{read.ctd}()},
\code{\link{setFlags,ctd-method}},
\code{\link{subset,ctd-method}},
\code{\link{summary,ctd-method}},
\code{\link{woceNames2oceNames}()},
\code{\link{woceUnit2oceUnit}()},
\code{\link{write.ctd}()}

Other things related to rsk data: 
\code{\link{[[,rsk-method}},
\code{\link{[[<-,rsk-method}},
\code{\link{as.rsk}()},
\code{\link{plot,rsk-method}},
\code{\link{read.rsk}()},
\code{\link{rsk-class}},
\code{\link{rskPatm}()},
\code{\link{rskToc}()},
\code{\link{rsk}},
\code{\link{subset,rsk-method}},
\code{\link{summary,rsk-method}}
}
\author{
Dan Kelley
}
\concept{things related to ctd data}
\concept{things related to rsk data}
