% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amsr.R
\docType{data}
\name{amsr}
\alias{amsr}
\title{An amsr dataset for waters near Nova Scotia}
\usage{
data(amsr)
}
\description{
This is a composite satellite image combining views for
2020 August 9, 10 and 11, trimmed from a world view to a view
spanning 30N to 60N and 80W to 40W; see \dQuote{Details}.
}
\details{
The following code was used to create this dataset.
\preformatted{
library(oce)
data(coastlineWorldFine, package="ocedata")
d1 <- read.amsr(download.amsr(2020, 8,  9, "~/data/amsr"))
d2 <- read.amsr(download.amsr(2020, 8, 10, "~/data/amsr"))
d3 <- read.amsr(download.amsr(2020, 8, 11, "~/data/amsr"))
d <- composite(d1, d2, d3)
amsr <- subset(d,    -80 < longitude & longitude < -40)
amsr <- subset(amsr,  30 < latitude  &  latitude <  60)
}
}
\examples{
library(oce)
data(coastlineWorld)
data(amsr)
plot(amsr, "SST")
lines(coastlineWorld[["longitude"]], coastlineWorld[["latitude"]])

}
\seealso{
Other satellite datasets provided with oce: 
\code{\link{landsat}}

Other datasets provided with oce: 
\code{\link{adp}},
\code{\link{adv}},
\code{\link{argo}},
\code{\link{cm}},
\code{\link{coastlineWorld}},
\code{\link{ctdRaw}},
\code{\link{ctd}},
\code{\link{echosounder}},
\code{\link{landsat}},
\code{\link{lisst}},
\code{\link{lobo}},
\code{\link{met}},
\code{\link{ocecolors}},
\code{\link{rsk}},
\code{\link{sealevelTuktoyaktuk}},
\code{\link{sealevel}},
\code{\link{section}},
\code{\link{topoWorld}},
\code{\link{wind}},
\code{\link{xbt}}

Other things related to amsr data: 
\code{\link{[[,amsr-method}},
\code{\link{[[<-,amsr-method}},
\code{\link{amsr-class}},
\code{\link{composite,amsr-method}},
\code{\link{download.amsr}()},
\code{\link{plot,amsr-method}},
\code{\link{read.amsr}()},
\code{\link{subset,amsr-method}},
\code{\link{summary,amsr-method}}
}
\concept{datasets provided with oce}
\concept{satellite datasets provided with oce}
\concept{things related to amsr data}
