% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adv.R
\docType{class}
\name{adv-class}
\alias{adv-class}
\title{Class to Store adv Data}
\description{
This class holds data from acoustic-Doppler velocimeters.
}
\details{
A file containing ADV data is usually recognized by Oce, and so
\code{\link[=read.oce]{read.oce()}} will usually read the data.  If not, one may use the
general ADV function \code{\link[=read.adv]{read.adv()}} or specialized variants
\code{\link[=read.adv.nortek]{read.adv.nortek()}}, \code{\link[=read.adv.sontek.adr]{read.adv.sontek.adr()}} or
\code{\link[=read.adv.sontek.text]{read.adv.sontek.text()}}.

ADV data may be plotted with \code{\link[=plot,adv-method]{plot,adv-method()}} function, which is a
generic function so it may be called simply as \code{plot(x)}, where
\code{x} is an \linkS4class{adv} object.

Statistical summaries of ADV data are provided by the generic function
\code{\link[=summary,adv-method]{summary,adv-method()}}.

Conversion from beam to xyz coordinates may be done with
\code{\link[=beamToXyzAdv]{beamToXyzAdv()}}, and from xyz to enu (east north up) may be done
with \code{\link[=xyzToEnuAdv]{xyzToEnuAdv()}}.  \code{\link[=toEnuAdv]{toEnuAdv()}} may be used to
transfer either beam or xyz to enu.  Enu may be converted to other
coordinates (e.g. aligned with a coastline) with
\code{\link[=enuToOtherAdv]{enuToOtherAdv()}}.
}
\section{Slots}{

\describe{
\item{\code{data}}{As with all \code{oce} objects, the \code{data} slot
for \code{adv} objects is a
\link{list} containing the main data for the object.
The key items stored in this slot include \code{time} and \code{v}.}

\item{\code{metadata}}{As with all \code{oce} objects, the \code{metadata} slot
for \code{adv} objects is a \link{list} containing
information about the \code{data} or about the object itself.
Examples that are of common interest include \code{frequency}, \code{oceCordinate}, and \code{frequency}.}

\item{\code{processingLog}}{As with all \code{oce} objects, the \code{processingLog} slot
for \code{adv} objects is a
\link{list} with entries describing the creation and evolution
of the object. The contents are updated by various \code{oce} functions to
keep a record of processing steps.  Object summaries and
\code{\link[=processingLogShow]{processingLogShow()}} both display the log.}
}}

\section{Modifying slot contents}{


Although the \code{[[<-} operator may permit modification of the contents
of \linkS4class{adv} objects (see \code{\link{[[<-,adv-method}}),
it is better to use \code{\link[=oceSetData]{oceSetData()}} and \code{\link[=oceSetMetadata]{oceSetMetadata()}},
because those functions save an entry in the \code{processingLog}
that describes the change.
}

\section{Retrieving slot contents}{


The full contents of the \code{data} and \code{metadata} slots of a \linkS4class{adv}
object may be retrieved in the standard R way using \code{\link[=slot]{slot()}}. For
example \code{slot(o,"data")} returns the \code{data} slot of an object named \code{o},
and similarly \code{slot(o,"metadata")} returns
the \code{metadata} slot.

The slots may also be obtained with the \code{\link{[[,adv-method}}
operator, as e.g. \code{o[["data"]]} and \code{o[["metadata"]]}, respectively.

The \code{\link{[[,adv-method}} operator can also
be used to retrieve items from within the \code{data} and \code{metadata} slots.
For example, \code{o[["temperature"]]} can be used to retrieve temperature
from an object containing that quantity. The rule is that a named
quantity is sought first within the object's \code{metadata} slot,
with the \code{data} slot being checked only if \code{metadata} does not
contain the item. This \code{[[} method can also be used to get
certain derived quantities, if the object contains sufficient
information to calculate them. For example, an object that holds
(practical) salinity, temperature and pressure, along with
longitude and latitude, has sufficient information to compute
Absolute Salinity, and so \code{o[["SA"]]} will yield the
calculated Absolute Salinity.

It is also possible to find items more directly, using \code{\link[=oceGetData]{oceGetData()}} and
\code{\link[=oceGetMetadata]{oceGetMetadata()}}, but neither of these functions can
retrieve derived items.
}

\examples{
data(adv)
adv[["v"]] <- 0.001 + adv[["v"]] # add 1mm/s to all velocity components

}
\seealso{
Other classes provided by oce: 
\code{\link{adp-class}},
\code{\link{argo-class}},
\code{\link{bremen-class}},
\code{\link{cm-class}},
\code{\link{coastline-class}},
\code{\link{ctd-class}},
\code{\link{lisst-class}},
\code{\link{lobo-class}},
\code{\link{met-class}},
\code{\link{oce-class}},
\code{\link{odf-class}},
\code{\link{rsk-class}},
\code{\link{sealevel-class}},
\code{\link{section-class}},
\code{\link{topo-class}},
\code{\link{windrose-class}},
\code{\link{xbt-class}}

Other things related to adv data: 
\code{\link{[[,adv-method}},
\code{\link{[[<-,adv-method}},
\code{\link{adv}},
\code{\link{beamName}()},
\code{\link{beamToXyz}()},
\code{\link{enuToOtherAdv}()},
\code{\link{enuToOther}()},
\code{\link{plot,adv-method}},
\code{\link{read.adv.nortek}()},
\code{\link{read.adv.sontek.adr}()},
\code{\link{read.adv.sontek.serial}()},
\code{\link{read.adv.sontek.text}()},
\code{\link{read.adv}()},
\code{\link{rotateAboutZ}()},
\code{\link{subset,adv-method}},
\code{\link{summary,adv-method}},
\code{\link{toEnuAdv}()},
\code{\link{toEnu}()},
\code{\link{velocityStatistics}()},
\code{\link{xyzToEnuAdv}()},
\code{\link{xyzToEnu}()}
}
\concept{classes provided by oce}
\concept{things related to adv data}
