% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coastline.R
\name{read.coastline}
\alias{read.coastline}
\title{Read a Coastline File}
\usage{
read.coastline(
  file,
  type = c("R", "S", "mapgen", "shapefile", "openstreetmap"),
  debug = getOption("oceDebug"),
  monitor = FALSE,
  processingLog
)
}
\arguments{
\item{file}{name of file containing coastline data.}

\item{type}{type of file, one of \code{"R"}, \code{"S"}, \code{"mapgen"},
\code{"shapefile"} or \code{"openstreetmap"}.}

\item{debug}{set to TRUE to print information about the header, etc.}

\item{monitor}{print a dot for every coastline segment read (ignored except
for reading "shapefile" type)}

\item{processingLog}{if provided, the action item to be stored in the log.
(Typically only provided for internal calls; the default that it provides is
better for normal calls by a user.)}
}
\value{
a \linkS4class{coastline} object.
}
\description{
Read a coastline file in R, Splus, mapgen, shapefile, or openstreetmap
format.
The S and R formats are identical, and consist of two columns, lon and lat,
with land-jump segments separated by lines with two NAs.
The MapGen format is of the form \preformatted{ # -b -16.179081 28.553943
-16.244793 28.563330 } BUG: the 'arc/info ungenerate' format is not yet
understood.
}
\author{
Dan Kelley
}
