% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odf.R
\name{plot,odf-method}
\alias{plot,odf-method}
\alias{plot.odf}
\title{Plot an ODF Object}
\usage{
\S4method{plot}{odf}(x, blanks = TRUE, debug = getOption("oceDebug"))
}
\arguments{
\item{x}{an \linkS4class{odf} object.}

\item{blanks}{A logical value that indicates whether to include dummy
plots for data items that lack any finite values.}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed. If one function calls another, it usually reduces the value of
\code{debug} first, so that a user can often obtain deeper debugging
by specifying higher \code{debug} values.}
}
\description{
Plot data contained within an ODF object,
using \code{\link[=oce.plot.ts]{oce.plot.ts()}} to create panels of time-series plots for
all the columns contained in the \code{odf} object (or just those that
contain at least one finite value, if \code{blanks} is \code{FALSE}).
If the object's \code{data} slot does not contain \code{time}, then
\code{\link[=pairs]{pairs()}} is used to plot all the elements in the \code{data}
slot that contain at least one finite value.
These actions are both
crude and there are no arguments to control the behaviour, but this
function is really just a stop-gap measure, since in practical work
\linkS4class{odf} objects are usually cast to other types, and those types
tend to have more useful plots.
}
\seealso{
Other functions that plot oce data: 
\code{\link{plot,adp-method}},
\code{\link{plot,adv-method}},
\code{\link{plot,amsr-method}},
\code{\link{plot,argo-method}},
\code{\link{plot,bremen-method}},
\code{\link{plot,cm-method}},
\code{\link{plot,coastline-method}},
\code{\link{plot,ctd-method}},
\code{\link{plot,gps-method}},
\code{\link{plot,ladp-method}},
\code{\link{plot,landsat-method}},
\code{\link{plot,lisst-method}},
\code{\link{plot,lobo-method}},
\code{\link{plot,met-method}},
\code{\link{plot,rsk-method}},
\code{\link{plot,satellite-method}},
\code{\link{plot,sealevel-method}},
\code{\link{plot,section-method}},
\code{\link{plot,tidem-method}},
\code{\link{plot,topo-method}},
\code{\link{plot,windrose-method}},
\code{\link{plot,xbt-method}},
\code{\link{plotProfile}()},
\code{\link{plotScan}()},
\code{\link{plotTS}()},
\code{\link{tidem-class}}

Other things related to odf data: 
\code{\link{CTD_BCD2014666_008_1_DN.ODF.gz}},
\code{\link{ODF2oce}()},
\code{\link{ODFListFromHeader}()},
\code{\link{ODFNames2oceNames}()},
\code{\link{[[,odf-method}},
\code{\link{[[<-,odf-method}},
\code{\link{odf-class}},
\code{\link{read.ctd.odf}()},
\code{\link{read.odf}()},
\code{\link{subset,odf-method}},
\code{\link{summary,odf-method}}
}
\author{
Dan Kelley
}
\concept{functions that plot oce data}
\concept{things related to odf data}
